package org.apereo.cas;

import module java.base;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;

/**
 * This is {@link MongoDbProperty}.
 *
 * @author Misagh Moayyed
 * @since 5.0.0
 */
@Document
@Getter
@Setter
@EqualsAndHashCode
@SuppressWarnings("NullAway.Init")
public class MongoDbProperty implements Serializable {

    @Serial
    private static final long serialVersionUID = -8152946700415601078L;
    
    @Id
    private String id;

    @Indexed
    private String name;

    private Object value;
}
