package org.apereo.cas.acct;

import module java.base;
import org.apereo.cas.acct.provision.AccountRegistrationProvisioner;

/**
 * This is {@link AccountRegistrationService}.
 *
 * @author Misagh Moayyed
 * @since 6.5.0
 */
public interface AccountRegistrationService {
    /**
     * Implementation bean name.
     */
    String BEAN_NAME = "accountMgmtRegistrationService";

    /**
     * Gets account mgmt registration property loader.
     *
     * @return the account mgmt registration property loader
     */
    AccountRegistrationPropertyLoader getAccountRegistrationPropertyLoader();

    /**
     * Gets account registration username builder.
     *
     * @return the account registration username builder
     */
    AccountRegistrationUsernameBuilder getAccountRegistrationUsernameBuilder();

    /**
     * Gets account registration request validator.
     *
     * @return the account registration request validator
     */
    AccountRegistrationRequestValidator getAccountRegistrationRequestValidator();

    /**
     * Gets account registration provisioner.
     *
     * @return the account registration provisioner
     */
    AccountRegistrationProvisioner getAccountRegistrationProvisioner();

    /**
     * Create token.
     *
     * @param registrationRequest the registration request
     * @return the string
     */
    String createToken(AccountRegistrationRequest registrationRequest);

    /**
     * Validate token.
     *
     * @param token the token
     * @return the account registration request
     * @throws Exception the exception
     */
    AccountRegistrationRequest validateToken(String token) throws Exception;
}
