---
layout: default
title: CAS - Web Flow Customization
category: Webflow Management
---

{% include variables.html %}

# Client-side Sessions

CAS provides a facility for storing flow execution state on the client in Spring Webflow. Flow state is stored as an encoded byte
stream in the flow execution identifier provided to the client when rendering a view. By default, CAS automatically attempts to store
and keep track of this state on the client in an encrypted form via encryption and signing keys
to remove the need for session cleanup, termination and replication.

{% include_cached casproperties.html properties="cas.webflow.crypto,cas.webflow.session" excludes=".server" %}

In the event that keys are not generated by the deployer, CAS will attempt to auto-generate keys and will output
the result for each respective key. The deployer MUST attempt to copy the generated keys to
their CAS properties file, especially when running a multi-node CAS deployment. Failure to do so will prevent CAS
to properly decrypt and encrypt the webflow state and will prevent successful single sign-on.

<div class="alert alert-warning">:warning: <strong>Usage Warning!</strong><p>
While the above settings are all optional, it is recommended that you provide your own 
configuration and settings for encrypting and transcoding of the web session state.</p></div>
