---
layout: default
title: CAS - Google Authenticator Authentication
category: Multifactor Authentication
---

{% include variables.html %}

# Google Authenticator Authentication

Google Authenticator generates 2-step verification codes on your phone. With 2-step 
verification signing in will require a code generated by the 
Google Authenticator app in addition to primary authentication. Learn 
more about the topic [here](https://en.wikipedia.org/wiki/Google_Authenticator).

<div class="alert alert-info">:information_source: <strong>Remember</strong><p>
Support for Google Authenticator is not about supporting the mobile application itself. 
This is about supporting the TOTP algorithm that is used by the application to generate
time-based one-time passwords. Any compliant mobile application that can generate TOTP codes
can be used with CAS including LastPass, Microsoft Authenticator, Authy, etc.
</p></div>

## Configuration

Support is enabled by including the following module in the overlay:

{% include_cached casmodule.html group="org.apereo.cas" module="cas-server-support-gauth" %}

{% include_cached casproperties.html properties="cas.authn.mfa.gauth" includes=".core,.crypto" %}

### Bypass

{% include_cached casproperties.html properties="cas.authn.mfa.gauth" includes=".bypass" %}

## Actuator Endpoints

The following endpoints are provided by CAS:

{% include_cached actuators.html endpoints="gauthCredentialRepository" %}

## Token Repository

In order to prevent reuse of tokens issued, CAS will attempt to keep track of 
tokens that are successfully used to authenticate the user.
The repository that holds registration records and tokens is periodically 
scanned and cleaned up so that expired and previously used tokens
may be removed.

{% include_cached casproperties.html properties="cas.authn.mfa.gauth.cleaner" %}

## Registration

By default, an account registry implementation is included that collects user 
device registrations and saves them into memory.
Issued tokens are also captured into a self-cleaning cache to prevent token 
reuse for a configurable period of time.
This option should only be used for demo and testing purposes. Production 
deployments of this feature will require a separate
implementation of the registry that is capable to register accounts into persistent storage.

Note that each individual account is allowed to register multiple devices to be 
used later for multifactor authentication. Duration the
authentication flow, the user will be asked to select the appropriate device for 
authentication if multiple device registration records
are found. The ability to handle multiple device registration 
records can be controlled via CAS settings.

| Storage     | Description                                                                      |
|-------------|----------------------------------------------------------------------------------|
| JPA         | [See this guide](GoogleAuthenticator-Authentication-Registration-JPA.html).      |
| MongoDb     | [See this guide](GoogleAuthenticator-Authentication-Registration-MongoDb.html).  |
| DynamoDb    | [See this guide](GoogleAuthenticator-Authentication-Registration-DynamoDb.html). |
| Redis       | [See this guide](GoogleAuthenticator-Authentication-Registration-Redis.html).    |
| LDAP        | [See this guide](GoogleAuthenticator-Authentication-Registration-LDAP.html).     |
| REST        | [See this guide](GoogleAuthenticator-Authentication-Registration-Rest.html).     |
| JSON        | [See this guide](GoogleAuthenticator-Authentication-Registration-JSON.html).     |

## REST Protocol Credential Extraction 

In the event that the [CAS REST Protocol](../protocol/REST-Protocol.html) is turned on, a special credential extractor 
is injected into the REST authentication engine in order to recognize credentials and authenticate them as part of the REST request. 
The expected parameter name in the request body is `gauthotp`. The account identifier may also 
be passed using the `gauthacct` parameter in the request body.

## Account Profile Management

The integration with Google Authenticator is able to provide user device registration information 
to the account profile management feature in CAS. [See this guide](../registration/Account-Management-Overview.html) for better details.

