---
layout: default
title: CAS - ClearPass
category: Authentication
---

{% include variables.html %}

# ClearPass: Credential Caching and Replay

To enable single sign-on into some legacy applications it may be necessary to provide them with the actual password.
While such approach inevitably increases security risk, at times this may be a necessary evil in order to integrate
applications with CAS.

<div class="alert alert-warning">:warning: <strong>Usage Warning!</strong><p>ClearPass is turned off by default.
No applications will be able to obtain the user credentials unless ClearPass is explicitly turned on by the
below configuration. Think <strong>VERY CAREFULLY</strong> before turning on this feature, as it <strong>MUST</strong> be
the last resort in getting an integration to work...maybe not even then.</p></div>

## Overview

CAS is able to issue the credential password directly in the CAS validation response. This previously was handled
via a proxy authentication sequence and obtaining a proxy-granting ticket for the ClearPass service and was necessary
in order to establish trust between the client application and the CAS server. This document describes the configuration
that can be applied in order to receive the credential password as an attribute in the CAS validation response.

In order to successfully establish trust between the
CAS server and the application, private/public key pairs are generated by the client application and then
**the public key** distributed and configured inside CAS. CAS will use the public key to encrypt the credential
password and will issue a new attribute `<credential>` in the validation response, only if the service is authorized to receive it.

Note that the return of the credential is only carried out by the CAS validation response, provided the client
application issues a request to the `/p3/serviceValidate` endpoint  (or `/p3/proxyValidate`). Other means of
returning attributes to CAS, such as SAML1 will **not** support the additional returning of this value.

Also note that CAS by default attempts to encrypt the cached credential in memory via its own pre-generated keys
for signing and encryption. When the attribute is to be released to the application, CAS will internally decode
the credential first and then will attempt to encrypt it again this time using the service's public key credentials.


<div class="alert alert-info">:information_source: <strong>ClearPass via Proxying!</strong><p>CAS no longer supports retrieving
the credential via the proxying mechanism. Applications that intend to obtain the credential
need to be updated to account for the following approach described here.</p></div>


## Cache Credential

Enable the caching and capturing of the credential in CAS properties.

{% include_cached casproperties.html properties="cas.clearpass." %}

## Create Keys

The keypair must be generated by the application itself that wishes to obtain the user credential.
The public key is shared with CAS. The private key is used by the application to decrypt the credential.

```bash
openssl genrsa -out private.key 1024
openssl rsa -pubout -in private.key -out public.key -inform PEM -outform DER
openssl pkcs8 -topk8 -inform PEM -outform DER -nocrypt -in private.key -out private.p8
```

Note that while `1024` is perfectly fine, you may need to adjust the key size to larger values such
as `4096` in order to allow CAS to encrypt credentials that are too long in length.

## Register Public Key

Once you have received the public key from the client application owner, it must be first
registered inside the CAS server's service registry. The service that holds the public key above must also
be authorized to receive the password as an attribute for the given attribute release policy of choice.

```json
{
  "@class" : "org.apereo.cas.services.CasRegisteredService",
  "serviceId" : "^https://.+",
  "attributeReleasePolicy" : {
    "@class" : "org.apereo.cas.services.ReturnAllowedAttributeReleasePolicy",
    "authorizedToReleaseCredentialPassword" : true
  },
  "publicKey" : {
    "@class" : "org.apereo.cas.services.RegisteredServicePublicKeyImpl",
    "location" : "classpath:public.key",
    "algorithm" : "RSA"
  }
}
```

## Decrypt the Password

Once the client application has received the `credential` attribute in the CAS validation response, it can decrypt
it via its own private key. Since the attribute is base64 encoded by default, it needs to be decoded first before
decryption can occur. Here's a sample code snippet:

```java
var attributes = ...
var encodedPsw = (String) attributes.get("credential");

/* Use the private.key file generated above. */
var privateKey = ...
var cipher = Cipher.getInstance(privateKey.getAlgorithm());
var cred64 = decodeBase64(encodedPsw);
cipher.init(Cipher.DECRYPT_MODE, privateKey);
var cipherData = cipher.doFinal(cred64);
return new String(cipherData);
```
