---
layout: default
title: CAS - AWS CLI Integration
category: Integration
---

{% include variables.html %}

# Overview

The functionality described here presents a dedicated integration strategy between CAS and AWS. Support is enabled by 
including the following dependency in the overlay:

{% include_cached casmodule.html group="org.apereo.cas" module="cas-server-support-aws" %}

## Configuration

{% include_cached casproperties.html properties="cas.amazon-sts." %}

## Actuator Endpoints

The following endpoints are provided by CAS:

{% include_cached actuators.html endpoints="awsSts" %}

## Temporary Security Credentials

For convenience you can simply copy and paste the temporary AWS access credentials
generated above to set them as environment variables or save the output into `~/.aws/credentials` 
that would be loaded and recognized by AWS CLI given the profile name.

The AWS CLI stores sensitive credential information that you specify 
with `aws configure` in a local file named `credentials`, in a folder named `.aws` in your 
home directory. The less sensitive configuration options that you specify with aws 
configure are stored in a local file named `config`, also stored in the `.aws` folder in your home directory.

To learn more about AWS CLI, please [see this guide](https://docs.aws.amazon.com/cli/latest).
  
Obtaining temporary security credentials can be done using the following integration strategies.

### Roles

Obtaining temporary security credentials from AWS STS is done using the `AssumeRole` API operation. Typically, you use 
this API within your account or for cross-account access. 

The temporary security credentials created by this operation can be used to make API calls to 
any AWS service with the exception of AWS STS `GetFederationToken` or `GetSessionToken` API operations.

To assume a role from a different account, your AWS account must be trusted by the role. The trust 
relationship is defined in the role's trust policy when the role is created. That trust
policy states which accounts are allowed to delegate that access to users in the account. A user who 
wants to access a role in a different account must also have permissions 
that are delegated from the user account administrator. The administrator must 
attach a policy that allows the user to call this operation for the ARN of the role in 
the other account.
         
Roles are expected to be found under a pre-defined attribute for the principal. If more than one role is found, a pre-selected
role can be specified using the `roleArn` parameter. The session name for the role is automatically generated by CAS. Role attribute
values are expected to be in the format of `[\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]+`

### Session Tokens

Obtaining temporary security credentials from AWS STS is done using the `GetSessionToken` API operation. The primary occasion for
calling this operation is when a user must be authenticated with multi-factor authentication (MFA). The authenticated user can qualify and
initiate multifactor authentication using the
available [multifactor authentication triggers](../mfa/Configuring-Multifactor-Authentication-Triggers.html).

On required permissions Amazon Web Services states,

> No permissions are required for a user to get a session token. The purpose of the
API operation is to authenticate the user using MFA. You cannot use policies to control authentication operations.

### Granted Permissions

On granted permissions Amazon Web Services states,

> If the API is called with the credentials of an IAM user, the temporary security 
> credentials have the same permissions as the IAM user. Similarly, if 
> the API is called with AWS account root user credentials, the temporary security credentials have root user permissions.

AWS recommends that you do not call the API with root user 
credentials. Instead, create IAM users with the
permissions they need. Then use these IAM users for everyday interaction with AWS.

Note that you **cannot** use the credentials to call IAM or AWS STS 
API operations. You **can** use them to call API operations for other AWS services.
