---
layout: default
title: CAS - Project Management Committee
---

# Project Management Committee

CAS is governed by a Project Management Committee (PMC) modeled after Apache-style PMCs. All PMC-related matters, including new nominations of
members MUST take place on the [mailing list](/cas/Mailing-Lists.html).

## Members

The current *core* members of the PMC are:

- [Misagh Moayyed](https://github.com/mmoayyed) [Chairman]
- [Jérôme Leleu](https://github.com/leleuj)
- [Hal Deadman](https://github.com/hdeadman)

Emeritus members are:

- [Bill Thompson](https://github.com/wgthom)
- [Daniel Frett](https://github.com/frett)
- [Travis Schmidt](https://github.com/tsschmidt)
- [Dmitriy Kopylenko](https://github.com/dima767)
- [Timur Duehr](https://github.com/tduehr)
- [Scott Battaglia](https://github.com/battags)
- [Jeff Sittler](https://github.com/mindblender)
- [Andrew Petro](https://github.com/apetro)
- [Julien Huon](https://github.com/julienhuon)
- [Robert Oschwald](https://github.com/robertoschwald)
- [Marvin Addison](https://github.com/serac)

## Structure

The PMC is composed of members and a chair who has executive authority over the committee and reports to the Apereo board.
The most common authority exercised by the chair is to appoint additional PMC members as necessary. Thus the chair
may bootstrap the committee. The board may appoint a chair in extreme circumstances (i.e. dysfunction, defunct),
but the chair is typically appointed by PMC vote. CAS project developers with commit access to the official project source code
repository are automatically PMC members; thus a committer is a PMC member. The PMC chair may or may not be a committer.

## Voting

All voting MUST be conducted over a period of at least 72 hours on a project mailing list; more time SHOULD be allotted for special
situations such as holidays and other occasions where large numbers of PMC members may be offline for longer-than-normal periods.
Voting is by lazy consensus where at least two +1 votes is sufficient to move forward and a single -1 vote is sufficient to block a
proposal. Voting SHOULD strive for consensus.

All PMC member votes are equal; the chair has no veto power.

### Timespan

Does voting stop after two +1 or one -1 or is it not tallied until the voting period closes?

Voting is open for at least `72h`. Any measure is effectively dead with a `-1` vote, so if a `-1` comes in a minute after voting starts there's really no point
in waiting any longer. The value of a `72h` window is that it affords more time for dissenters. The voting process is intended to emphasize and produce consensus,
which is the most important aspect.

## PMC Chair Nomination

The nomination of a PMC chair requires a vote: a majority of `+1` is required and no `-1`. The vote **MUST** happen **PRIVATELY** on the cas-pmc mailing list.
Members who abstain from a vote are simply considered in support of the vote via lazy consensus.

## Committer Nomination

The nomination of a committer requires a vote: a majority of `+1` is required and no `-1`. The vote **MUST** happen **PRIVATELY** on the cas-pmc mailing list.
The vote is proposed by one of the current committers. All members of the community have the right to become a committer, solely and exclusively
on the grounds of the meritocracy. Members who abstain from a vote are simply considered in support of the vote via lazy consensus.

## Communication

Communication happens primarily by public mailing lists. Exceptions are issues that require discretion or confidentiality;
private lists are the appropriate channel in those situations. Communication may also occur through other appropriate channels as needed,
such as video/voice conference calls, IRC and IM. No official decisions may be made via any means other than voting on a project mailing list;
if it didn't happen on list, it didn't happen. Discussions that occur in side channels such as IRC and IM SHOULD be summarized on a mailing list
when they may impact decision making processes. The committee SHOULD make an effort to meet periodically via a high-bandwidth synchronous medium
such as in-person meetings at conferences or voice/video conference calls.

## Obligations

PMC members agree to abide by and enforce Apereo foundation legal policy and foundation branding/marketing policies.
PMC members SHOULD notify of intent to leave or become inactive in order to facilitate replacement or recruitment of new members.

