---
layout: default
title: CAS - Contributor Guidelines
---

# Contributor Guidelines

We want to start by saying thank you for using CAS and for all the work done by all
who catch bugs, build enhancements, identify performance improvements and help with documentation. Every contribution is meaningful, so thank you
for participating. Here are a few guidelines that we ask you to follow so we can successfully address your contribution.

The goal of this guide is to, very simply put, help you learn how to catch fish.

Shed all of your fears of making a mistake as part of your contributions to the project. Practice makes perfect and
we are all here to help you as much as we can so you can ultimately become an independent contributor to the project. It's OK
to make mistakes and it does take some time, effort and energy to improve the state of proposals and
contributions. So do not be discouraged, keep at it and if you find anything that is unclear along the way, do not hesitate to ask questions.

The overarching theme of this guide starts with the following questions:

1. What is the Apereo CAS project policy on accepting contributions?
2. How may one, seriously and in a step-wise fashion, get started with contributions?

## What do you mean by contribution?

In the context of the Apereo CAS project, a *contribution* generally means the giving or supplying
of bug fixes, modest feature enhancements, documentation improvements, test cases, etc back to the project typically in the form of a pull request or patch.
All such items and donations play a significant part in improving the state of the project and the software for all involved. Such contributions
are concrete, actionable and measurable and signal back to the larger community that you, the contributor, are actively involved, engaged and concerned
with the overall health status and future direction of the project. Of course, for non-technical folks, contributions do not always equal writing some
kind of code. That is only one of many possible options. We hope that you consider that as a good starting place and when all else fails,
consider [supporting the project](https://apereo.github.io/cas/Support.html).

## What do I work on?

A certain number of projects in open source try to advertise, label and tag work items, issues and tasks
which they think might be good candidates for contributions. This is generally and
often *not* the Apereo CAS project policy. The policy is much simpler than that.

It goes something like this:

> Everything is ideal for contributions.

In other words,

- There is no *"We vs. You"*.
- There is no *"Some folks can only fix certain issues and some can't"*.
- There is no *"Person X made the change; so X must fix it too"* (aka code ownership)
- There is no *"I am just a user; you are the developers"*.

Of course, if you are a newcomer to the project and have just begun to understand the ins and outs of
the [CAS project codebase](https://apereo.github.io/2017/06/12/cas-codebase-overview/), there may certainly
be areas in which you might find more comfort to slowly get your feet wet. You're welcome to [ask for suggestions](https://apereo.github.io/cas/Mailing-Lists.html).
For the most part, the work item you wish to work on should be something you find interesting and enjoyable with some degree of practicality.

Remember that you are deploying open-source software, which means you have automatically become
a project/community member and a potential maintainer, whether you realize it or not. Staying in *consume-only* mode generally leads to poor results.

## What can I work on?

All contributions are extremely welcomed with open arms regardless of shape, size, and color. You may be
interested in helping with fixing typos, writing documentation, authoring test cases, developing code, squashing bugs, etc. All is welcome.

[More contributions simply equal more confidence](https://apereo.github.io/2017/03/08/the-myth-of-ga-rel/).

In other words, if you happen to come across a bothersome use case and/or something you consider a perfect
candidate for improvement and attention, you are most definitely, aggressively and wholeheartedly encouraged
to spend time and DNA to improve the quality of your Apereo CAS life. There is no point in silent suffering.

If you find that contributing to the project is at the moment out of your reach, don't
worry. There are resources, [here](https://www.coursera.org/) and [here](https://apereo.github.io/cas/Support.html) that
can provide training and support to get you started for the win.

## Should I open an issue first?

No.

If you have already identified an enhancement or a bug, it is STRONGLY recommended that you simply
submit a pull request to address the case. There is no need for special ceremony to create separate
issues. The pull request **IS** the issue and it will be tracked and tagged as such. Remember that this is
open-source software in an open and collaborative community. It's not "Some folks report issues and some
folks fix problems" software. You are for the most part and at all costs encouraged to submit patches that
fix the reported issue and remove pain, rather than waiting for someone to come along and fix it. As prescribed, there is no *"We vs. You"*.

Simply put:

> You are the one you have been waiting for.

Remember that doing something about an issue does not necessarily equal to you, the individual contributor,
writing code. That is only one of many [possible options](https://apereo.github.io/cas/Support.html). That said,
if you'd rather just report and catalog the issue to have others benefit from your discovery, it would be best if
you could share the use case and the problem at hand via community mailing lists, chatrooms and the likes of
StackOverflow under appropriate tags for easier discovery.

## What if I am not a developer?

If you have already diagnosed a problem or have found a use case for an attractive improvement and feature,
we strongly recommend you simply [walk down the path](https://github.com/apereo/cas/graphs/contributors) of
making that all a reality and *contribute* back. If you find yourself unable to do so, you will need to find
and procure resources that can [teach you the how-to](https://www.coursera.org/)
or [do it for you](https://apereo.github.io/cas/Support.html). Talk to your institution, company,
organization, supervisor, boss, mentor, architect, manager, director, CIO, CTO, CISO, etc and have them procure the right resources for the job.

Reporting an issue and hoping/waiting for someone else to magically come along and spend time, money and energy
to provide a fix for you is never an acceptable strategy. Quit waiting for the light at the end of the tunnel and light it yourself.

If you insist on being treated like a user, you then need to revisit and realign
expectations with [folks and resources](https://apereo.github.io/cas/Support.html) that can provide
you with the treatment you need. All of the work that goes into the development of a rich comprehensive
software platform is almost exclusively done voluntarily. Therefore, if you have expectations that
resemble something of a commercial support agreement with clauses that include promises, guarantees,
SLAs and follow-ups, you simply need to level up with an entity that provides that sort of functionality.

## I have an idea; It would be nice if...

It _would_ be nice. No, it would be fantastic, superb, marvelous and ultra great. Please consider
that lone ideas by themselves are more or less pointless unless they are executed and realized in
concrete form. There is no shortage of ideas; good or bad. There is a shortage of folks who are ready
and serious enough to execute and deliver the idea. This is very much a call to action and one that
allows you to graduate from a think-tank into a doer, a contributor, a promoter and a leader. If you
consider something to be worth doing, a very best thing you can do is to demonstrate concretely and
seriously, that it is, in fact, worth doing. Doing something about an issue or request does not
necessarily equal to you, the individual contributor, writing code. That is only one of many possible
options. We hope that you consider that as a good starting place and when all else fails,
consider [reaching out for support](https://apereo.github.io/cas/Support.html).

## I found a problem. Should I...?

Yes, you should. If you find something that you consider to be odd, wrong or wobbly behavior _**and**_
have found an alternative solution that removes the obstacle or delivers the case, please consider reporting
and sharing that improvement in form of a patch to the project so it can be discussed and potentially
accepted. There is no downside to this, as you engage and collaborate with community members concretely and
in action; It is quite possible that they may have found a better solution and might be able to share that with
you for longer prosperity. Be not afraid; the worst that could happen is someone stepping up to help you out with better options.

## How do I know who's working on what?

- Follow the *WIP Pattern* and submit early pull requests in Draft status. This is the recommended strategy from GitHub:

> Pull Requests are a great way to start a conversation of a feature, so start one as soon as possible-
> even before you are finished with the code. Your team can comment on the feature as it evolves,
> instead of providing all their feedback at the very end.

Or put another way:

> You’re opening pull requests when you start work, not when you’re finished.

There is of course the alternative: [ask](https://apereo.github.io/cas/Mailing-Lists.html).

## How frequently should I make progress?

If you do have a pending pull request available and one that might also be tagged as *WIP*, you are most
welcome to keep pushing to the underlying branch as frequently as you prefer. There is nothing spammy or
annoying about making progress on a *WIP* pull request. Nobody is going to get mad at you for making progress
and pushing changes, (That's what email filters, etc are for), so do not ever worry about annoying other
contributors and/or project members with the frequency of your progress notifications. Continue working on
the use case as often as you like and be sure to keep asking for feedback as you make progress.

<div class="alert alert-success">:sunny: <strong>Inactivity</strong><br/>Note that contributions and pull requests that remain inactive for a 
certain period get tagged as <i>Pending</i> and will be eventually closed automatically. Staleness 
is only allowed to a certain degree, but worry not. Any stale closed pull request can always be reopened and progress resumed without data loss.
</div>

## Can I backport a change to a maintenance branch?

Yes, absolutely. Provided the change fits the scope of the maintenance branch and its tracking release and assuming
the branch is still under care, you are more than welcome to move changes across the codebase's various branches as
much as needed to remove pain and improve.

<div class="alert alert-success">:sunny: <strong>Port Forward</strong><br/>Remember that changes applied to previous branches that target CAS versions in 
maintenance mode <b>MUST</b> be ported forward to the master branch as well, via a separate pull request.
</div>

## What if the change is too big?

Start by reviewing the [release policy](Release-Policy.html). The change
you have in mind should fit the scope of the release that is planned. If
needed, [please discuss](https://apereo.github.io/cas/Mailing-Lists.html) the release schedule and policy with other
community members to find alternative solutions and strategies for delivery.

## Do you know when X will be addressed?

Yes, absolutely. We know **EXACTLY** when defects and features will be addressed. The timeline is as follows:

- All work items are addressed when you propose, discuss, sponsor and **contribute** changes and tests in the form of a pull request.
- Or, after due discussions with the project and relevant stakeholders, you provide **funding and sponsorship** for the change and contract with someone or a commercial support provider to do the work on your behalf.
- Or, you might wait until a sympathetic stranger on the internet with access to funding or resources might share the same motivation and inclination and they would go through this process on your behalf.

As you observe, the timeline is extremely exact and predictable. Simply put, things get done when you get to them.

## Is it worth it?

The CAS project generally operates based on its own [maintenance policy](Maintenance-Policy.html). Before
making changes, you want to cross-check the CAS deployment you have today and ensure it is still and to what extent considered viable and
maintained by the project.

## How do I get on the roadmap?

By simply delivering the change and having it get merged into the codebase relevant branches. There is no predefined
roadmap for the project. Work items get completed based on the community's availability, interest, time and money. The
roadmap is the item **you** intend to work on, build and ultimately deliver to the project as a pull request.

## Is there a wishlist for future CAS versions?

You're welcome and encouraged to get in touch with the CAS community on the appropriate forums and chatrooms to
share your use case and ideas with others and brainstorm about variations and possibilities. Healthy and productive discussions
often help clear the path to better and more objective solutions. That said, if you are specifically looking for an idea repository where you would
log an idea or feature request for someone else to come along and spend time, money and energy to review and
provide a solution or enhancement for you, that place does not exist with the CAS project. As was noted earlier,
if you would like to see an enhancement in CAS, you are to either study, learn and do the work yourself and contribute that back
to the CAS project after having had the proper discussions with the wider developer community, or you can provide funding for
the work or contract with someone so they can do the work on your behalf. There are no other viable, sustainable options.

## Are there plans to...?

No. There are no plans.

CAS project development activity is largely based on **volunteer time and contributions**. Officially,
there are no contracts, commitments, timelines, schedules, or funding to plan for changes. Planning for
future changes and roadmap discussions in the absence of a time commitment, solid funding or sponsorship
seems unnecessary and can only feel like ceremonial, premature busywork especially as due dates for such
plans inevitably and almost always get pushed back and continue to eat dust given the absence of tooling
and resources. CAS open-source development is never done in vacuums. Generally speaking, work items are
done when contributors propose, discuss and **show up with pull requests** or when **funding and sponsorship**
for a change is made available. If you would like to see a change or feature in CAS, you're most welcome
to discuss and contribute or fund someone else's time and make it worth their while to do that for you.

<div class="alert alert-info">:information_source: <strong>The Hitchhiker's Guide to the CAS Galaxy</strong><p>A <i>problem</i> is 
only a problem, if and when you do something about the problem. Otherwise and by definition, there is no problem.</p></div>

## How often are changes released?

You can review the [release schedule](https://github.com/apereo/cas/milestones). Note
that the dates specified for each milestone are somewhat tentative and may be pushed around depending on need and severity.

As for general contributions, patches in form of pull requests are generally merged as
fast as possible provided they are in *good health*. This means a given pull request must pass
a series of automated checks that examine style, tests and such before it becomes eligible for
a merge. If your proposed pull request does not yet have the green marking, worry not. Keep
pushing to the branch that contains your change to auto-update the pull request and make life green again.

If you find that the project is not moving forward at a pace you find reasonable, simply *ping*
the pull request and gently remind someone to step forward and review the issue with you.

## How fast can I test changes?

Typically, `SNAPSHOT` releases are published by the automatic [CI process](https://github.com/apereo/cas/actions). As
soon as a patch is merged, you want to track its build status and once it turns green, you should be good to update
snapshots in your build script. Practically, this process can take up to 50 minutes or less. Refer to the `README`
file of the build script and the project documentation to learn how you may update the overlay to take advantage of the change.

This practically involves running the build with a `-U` or `--refresh-dependencies` command for Apache Maven and Gradle respectively.

## Can you publish a release this week?

No. The CAS project generally follows a somewhat fixed release schedule, and the schedule cannot
change per customer/client/project/user/vendor demands at random as publishing a release generally
requires quite a bit of management, scheduling and coordination. Remember that release dates are
always *subject to change*, but only if more time is needed to fix an issue or test a scenario based
on the feedback received from community users and testers. Of course, this is all based on a best-effort
basis and depends on how much funding and energy is available to work out fixes or test various
scenarios. If you are planning to go to production and cannot wait for the CAS release schedule, you
can build the project from sources and publish artifacts to your own artifact repositories to take
control of the release schedule yourself. For additional guarantees, please see the project license.
     
## How can I prepare for contributions to be accepted?

<p align="center">
<a href="https://github.com/apereo/cas/assets/1205228/e3cc2db3-2780-4b71-9e98-5c82580c7fca" data-lightbox="image-1">
  <img src="https://github.com/apereo/cas/assets/1205228/e3cc2db3-2780-4b71-9e98-5c82580c7fca">
</a>
</p>

If your pull request, idea or changeset is non-trivial, spans across multiple CAS modules, introduces new or 
changes fundamental aspects of the CAS design and architecture or presents an integration with an external 
system or product that might induce a heavy maintenance burden on others, there are a few things you can do in 
advance to prepare and start the process before sprinting into a coding effort:

- [Start a discussion](https://apereo.github.io/cas/Mailing-Lists.html) with the project developers to see if your changeset can be accepted and maintained by project developer community. You are essentially asking strangers on the internet to take on the maintenance and management effort of the feature, potentially long after your interest in the project, idea, enhancement or even your employer has disappeared. Are they OK with managing and maintaining this enhancement on your behalf? Do they have time and interest, and do they find the idea appealing and useful for the larger community?
- Start a discussion with the CAS user community to find sponsors, other users and collaborators to see who else might be interested to work on and use the feature. Does anybody else, other than your employer or customer, find this enhancement or change useful? Is anybody else serious-enough to collaborate with you to build, refine, test and ultimately deploy this change into production? Is anyone else available to potentially help you and the project with future contributions and the maintenance effort in subsequent CAS releases?
 
If you visit someone's residence with the intention of installing a ready-made swimming pool in the middle of the living room, you may want to give them a call first. They might be perfectly OK with it, but it would be practical to confirm first.

<div class="alert alert-info">:information_source: <strong>Stop Coding</strong><p>Do not start a coding effort right away with the intention of submitting a pull request, if you do not have enough support and buy-in from the project maintainers and the user community. If you show up out of the blue with a large changeset without prior notice or discussion, your pull request will most likely
remain stale for a long time and/or will eventually be closed.</p></div>

Once you have enough support from the CAS developer and user communities, start by reviewing the [release policy](Release-Policy.html) to determine the scope of your intended enhancement
and the target CAS version that would ship with your changes in place. When in doubt, [ask questions](https://apereo.github.io/cas/Mailing-Lists.html).

If the enhancement is rather substantial or provides an integration with an external system or product, a best course of action would be to:

- Build the enhancement as **external CAS module** outside the codebase in public as open-source software with a CAS-compatible license.
- Invite others to collaborate with you to define, refine, test, build and deploy the changeset into production.
- Give yourself, your team and the collaborators time to verify the changes, show commitment and build support. Time allows you to demonstrate activity and community interest beyond words and on-paper intentions so the overall community can see your extension, changeset or idea is useful, in-demand and appealing to others. You may need a week, a month, three years, or more.

With enough activity, demand, support and collaboration as demonstrated by you and others, you should be well on your way to work with the project maintainers to include the enhancement, likely via a series of pull requests and patches. It might of course turn out that you might be the only entity interested in the idea and you receive no support or encouragement from the community. This might indicate a red flag as you will be the single-parent of the change, carrying the maintenance burden solely on your own. If you are
 convinced that the changeset is absolutely vital for your needs, we recommend that you start or continue with the development in the open anyway. Others might step up to adopt, collaborate and improve the functionality over time. You never know. With time it will either get better, or the [trainman](https://en.wikipedia.org/wiki/List_of_Matrix_series_characters#Trainman) will take it back to the machine world.

## Why isn't my proposal accepted and merged yet?

Patches submitted to the codebase in form of pull requests are generally reviewed as quickly as possible
and most are often accepted. If you find your contribution to take longer
than *usual* to be merged, it's possible that the proposed changeset violates one or more of the following principles:

- **IMPORTANT**: The patch intends to fix a supposed problem and yet provides no automated, reproducible, verifiable way for one to **reproduce and verify** the issue other than anecdotal, descriptive, manual evidence.
- The patch fails to pass automated unit or integration tests.
- The patch fails to adhere to the project's styling guidelines.
- The patch fails to provide adequate unit or integration tests for the proposed changes.
- The patch fails to provide an explanation or objective for the proposed changes.
- The patch has remained stale for quite a while without any sign of contributor activity.
- The patch modifies system behavior without consensus, collective feedback or internal validation as unit or integration tests.
- The patch modifies a large number files, more than one could practically review in a timely manner.
- The patch presents a feature or behavior that is deemed too specialized or custom with unwarranted assumptions.
- The patch introduces too many (i.e. formatting) changes that are not related to the proposal's objective.
- The patch violates the general design principles of the codebase or introduces inconsistent/contradictory concepts that are difficult to maintain.

<div class="alert alert-success">:sunny: <strong>Remember</strong><br/>If you need help, please ask and seek clarification as often 
as you prefer. The shared objective of a pull request is not to judge or point fingers but to 
collaborate and make progress. Remain positive, optimistic with a healthy attitude towards comments and constructive feedback.
</div>

There may be accidental mistakes or infrastructure mishaps along the way. You're most welcome to ping the pull request and provide an
explanation and/or comment. In most, if not all, cases the patch is accepted.

## Functional Build

Before you do anything else, make sure you have a [functional build](Build-Process.html).

## How do I do this?

To successfully finish this exercise you need:

1. [Git](https://git-scm.com/downloads)
2. [IntelliJ IDEA](https://www.jetbrains.com/idea/download/)
3. [Java (JDK)](https://openjdk.org/)

### Fork the repository

First thing you need to do is to fork the CAS repository under your account. The
CAS repository is hosted on GitHub and is available [here](https://github.com/apereo/cas).

### Clone Repositories

There are much faster ways of cloning the codebase, but let's keep it simple for now:

```bash
git clone --recursive git@github.com:apereo/cas.git
cd cas
git remote add github-username git@github.com:github-username/cas.git
git checkout master
```

Next, if you simply list the remotes you should see:

```bash
origin  git@github.com:apereo/cas.git (fetch)
origin  git@github.com:apereo/cas.git (push)
github-username  git@github.com:github-username/cas.git (fetch)
github-username  git@github.com:github-username/cas.git (push)
```

### Fetch Submodules

You can use `git submodule update --init --recursive` to fetch all submodules linked to the repository.

### Workflow

You want to isolate your changes inside individual topics branches and never
commit anything to the `master` branch. The workflow more or less is the following:

1. Create topic branch.
2. Make changes and test.
3. Commit changes to branch.
4. Go back to #2 until you are satisfied.

<div class="alert alert-success">:sunny: <strong>Functional Build</strong><br/>You may want to ensure the codebase can be 
built locally from source. <a href="https://apereo.github.io/cas/developer/Build-Process.html">Follow this guide</a> to learn more.
</div>

### Create Branch

To create a topic branch for the change, execute:

```bash
git status
git checkout -b my-topic-branch-which-fixes-something
```

### Commit Changes

When you're ready to commit changes after having made changes, execute:

```bash
git add --all && git commit -am "This change fixes a problem"
```

Note that the `--all` flag adds *all* modified files in the project directory. If you
wish to pick and choose, you can either individually add files via a `git add fileName` command
one at a time or perhaps, it might be best to simply opt for a GUI client such
as [SourceTree](https://www.sourcetreeapp.com/) or [Git Extensions](https://github.com/gitextensions/gitextensions).

### Push Changes

Push your changes from the *local* branch to a *remote* branch of your fork:

```bash
git push github-username my-topic-branch-which-fixes-something
```

### Submit Pull Request

Next, create a pull request based on your branch to the CAS project. In this particular
case, the *target* branch is the `master` branch because your branch was created off of the `master` branch.

### Destination Branch

The CAS codebase dedicates specific branches to feature and major releases of the
software (i.e. `5.3.x`, `6.0.x`, etc). These branches will continue to live on in maintenance
mode until the release is declared EOL and form the basis of follow-up patch releases and
maintenance cycles. When you are preparing a pull request, please be sure to select the appropriate
target branch for the patch to ensure your change can be included in the coming maintenance release as scheduled.

<div class="alert alert-success">:sunny: <strong>Port Forward</strong><br/>Once more, please remember that changes applied to 
previous branches that target CAS versions in maintenance mode <b>MUST</b> be ported 
forward to the master branch as well, via a separate pull request.
</div>
