---
layout: default
title: CAS - OpenID Connect Authentication
category: Protocols
---
{% include variables.html %}

# JWKS Rotation - OpenID Connect Authentication

Key rotation is when a key is retired and replaced by generating a 
new cryptographic key. Rotating keys on a regular basis is an industry 
standard and follows cryptographic best practices.

You can manually rotate keys periodically to change the JSON web key (JWK) key, or you can configure the appropriate schedule
in CAS configuration so it would automatically rotate keys for you. 

<div class="alert alert-info">:information_source: <strong>Rotation Guidance</strong><p>
NIST guidelines seem to recommend a rotation schedule of at least once every two years. 
In practice, modest CAS deployments in size and scale tend to rotate keys once every six months, either 
manually or automatically on a schedule.
</p></div>

Keys that are generated by CAS and put into the keystore carry an extra `state` parameter that indicates
the lifecycle status of the assigned key. The following values are accepted lifecycle states:

| Value | Description                                                                            |
|-------|----------------------------------------------------------------------------------------|
| `0`   | The key is active and current, used for required operations.                           |
| `1`   | The key will be the next key used during key rotation.                                 |
| `2`   | The key is no longer used and active, and will be removed after revocation operations. |

CAS always signs with only one signing key at a time, typically the *very first key* listed and loaded from the keystore,
that is deemed active and current judging by the `state` parameter. For backward compatibility, the absence of this
parameter indicates that the key is active and current.

The dynamic discovery endpoint will always include both the current key and the next key, and it may also 
include the previous key(s) if the previous key has not yet been revoked. To provide a seamless experience in 
case of an emergency, client applications should be able to use any of the keys specified in the discovery document. 

{% include_cached casproperties.html properties="cas.authn.oidc.jwks" includes=".revocation,.rotation" %}

### Custom

It is possible to design and inject your own key rotation and revocation 
strategy into CAS using the following `@Bean` that would be registered in a `@AutoConfiguration` class:

```java
@Bean
public OidcJsonWebKeystoreRotationService oidcJsonWebKeystoreRotationService() {
    return new MyJsonWebKeystoreRotationService();
}
```

Your configuration class needs to be registered
with CAS. [See this guide](../configuration/Configuration-Management-Extensions.html) for better details.
