---
layout: default
title: CAS - Configuring SSO Session Cookie
category: SSO & SLO
---
{% include variables.html %}

# SSO Cookie

A ticket-granting cookie is an HTTP cookie set by CAS upon the establishment of a single sign-on session. This cookie maintains login
state for the client, and while it is valid, the client can present it to CAS in lieu of primary credentials.

The cookie value is linked to the active ticket-granting ticket, the remote IP address that initiated the request
as well as the user agent that submitted the request. The final cookie value is then encrypted and signed. 

These keys **MUST** be regenerated per your specific environment. Each key is a JSON Web Token with a 
defined length per the algorithm used for encryption and signing.

In the event that keys are not generated by the deployer, CAS will attempt to auto-generate keys and will output
the result for each respective key. The deployer MUST attempt to copy the generated keys over to the appropriate
settings in their CAS properties file, especially when running a multi-node CAS deployment. Failure to do so will prevent CAS
to properly decrypt and encrypt the cookie value and will prevent successful single sign-on.

<div class="alert alert-info">:information_source: <strong>Forced Authentication</strong>
<p>Each application can opt out of a single sign-on session on a per-request basis. The availability of this behavior
does depend on the authentication protocol used by the application. For example, applications that use the CAS protocol 
can opt out of single sign-on through the <code>renew</code> parameter or the CAS server may conditionally opt the 
service out based on the policies defined for the application in the service registry</p></div>

## Configuration

{% include_cached casproperties.html properties="cas.tgc" %}

The cookie has the following properties:

1. It is marked as secure.
2. Depending on container support, the cookie would be marked as http-only automatically.
3. The cookie value is encrypted and signed via secret keys that need to be generated upon deployment.

If keys are left undefined, on startup CAS will notice that no keys are defined and it 
will appropriately generate keys for you automatically. Your CAS logs will then show the following snippet:

```bash
WARN [...] - <Secret key for encryption is not defined. CAS will auto-generate the encryption key>
WARN [...] - <Generated encryption key ABC of size ... . The generated key MUST be added to CAS settings.>
WARN [...] - <Secret key for signing is not defined. CAS will auto-generate the signing key>
WARN [...] - <Generated signing key XYZ of size ... . The generated key MUST be added to CAS settings.>
```

You should then grab each generated key for encryption and signing, and put them inside your CAS properties for each setting.
If you wish you manually generate keys, you may [use the following tool](https://github.com/mitreid-connect/json-web-key-generator).

{% include_cached casproperties.html properties="cas.sso" %}

## SSO Expiration Policy

The single sign-on expiration policy that is tied to the CAS single sign-on cookie is mainly controlled by
a specific ticket type that represents the single sign-on session managed by the CAS server.

[See this page](../ticketing/Configuring-Ticket-Expiration-Policy-TGT.html) for more.

## SameSite Attribute
   
CAS configuration allows the deployer to control and modify the `SameAttribute` cookie attribute statically.
The deployer also has the option to generate this cookie attribute dynamically via the following strategies.

{% tabs samesitecookie %}

{% tab samesitecookie <i class="fa fa-file-code px-1"></i>Groovy %}
        
The cookie setting in CAS configuration may point to a Groovy script that is tasked to generate the `SameAttribute` cookie attribute.
The outline of the script may be as follows:

```groovy
import org.apereo.cas.web.cookie.*

def run(final Object... args) {
    def (request,response,context,logger) = args
    
    logger.info("Generating SameSite for ${context.name}")
    return "SameSite=Lax;"
}
```

The parameters that may be passed are as follows:

| Parameter  | Description                                                                                        |
|------------|----------------------------------------------------------------------------------------------------|
| `request`  | The HTTP request object.                                                                           |
| `response` | The HTTP response object.                                                                          |
| `context`  | The cookie configuration context that points to the cookie configuration and other helper objects. |
| `logger`   | The object responsible for issuing log messages such as `logger.info(...)`.                        |

{% endtab %}

{% tab samesitecookie <i class="fa-brands fa-java px-1"></i>Java %}

The cookie setting in CAS configuration may point to a Java class using its FQDN 
that is tasked to generate the `SameAttribute` cookie attribute.

```java
public class MyCookieSameSitePolicy implements CookieSameSitePolicy {
    @Override
    public Optional<String> build(HttpServletRequest request, 
                                  HttpServletResponse response, 
                                  CookieGenerationContext context) {
        return Optional.of("SameSite=Lax;");
    }
}
```

{% endtab %}

{% endtabs %}

## Cookie Generation for Renewed Authentications

By default, forced authentication requests that challenge the user for credentials
either via the [`renew` request parameter](../protocol/CAS-Protocol.html) (that is, using the CAS protocol),
or via [the service-specific setting](../services/Service-Management.html) of
the CAS service registry will always generate the ticket-granting cookie
nonetheless. What this means is, logging in to a non-SSO-participating application
via CAS nonetheless creates a valid CAS single sign-on session that will be honored on a
subsequent attempt to authenticate to a SSO-participating application.

The cookie generation strategy can also be customized on a per-application basis. For additional details, 
please [review this guide](../services/Configuring-Service-SSO-Policy.html).
