---
layout: default
title: CAS - Configuring Authentication Policy
category: Authentication
---
{% include variables.html %}

# REST - Authentication Policy

Contact a REST endpoint via `POST` to detect authentication policy.
The message body contains the CAS authenticated principal that can be used
to examine account status and policy.

{% include_cached casproperties.html properties="cas.authn.policy.rest" %}

Response codes from the REST endpoint are translated as such:

| Code         | Result                                          |
|--------------|-------------------------------------------------|
| `200`        | Successful authentication.                      |
| `403`, `405` | Produces a `AccountDisabledException`           |
| `404`        | Produces a `AccountNotFoundException`           |
| `423`        | Produces a `AccountLockedException`             |
| `412`        | Produces a `AccountExpiredException`            |
| `428`        | Produces a `AccountPasswordMustChangeException` |
| Other        | Produces a `FailedLoginException`               |
