---
layout: default
title: CAS - Basic Authentication
category: Authentication
---
{% include variables.html %}


# Basic Authentication

Verify and authenticate credentials using Basic Authentication.

Support is enabled by including the following dependency in the WAR overlay:

{% include_cached casmodule.html group="org.apereo.cas" module="cas-server-support-basic" %}

To access a CAS-protected application using a command-line client such as `curl`, the following command may be used:

```bash
curl <APPLICATION-URL> -L -u <USER>:<PASSWORD>
```

Use `--insecure -v` flags to bypass certificate validation and receive additional logs from `curl`. 

If your `APPLICATION-URL` and CAS server url are not on the same host, curl will **NOT** send the Basic Authentication header to the CAS 
server when redirected. This behavior in curl can be overridden by passing the `--location-trusted` flag to curl.

From CURL man page:

```bash
--location-trusted
        (HTTP/HTTPS) Like -L, --location, but will allow sending the name + password to all hosts that the site may redirect to. This may or may
        not introduce a security breach if the site redirects you to a site to which you'll send your authentication info 
        (which is plaintext in the case of HTTP Basic authentication).
```
