---
layout: default
title: CAS - Support
pdf: true
---

# Support

CAS is open source software supported primarily by an open and friendly community.
Our premier *free* support channel is community discussion mediated primarily via
[Mailing Lists](Mailing-Lists.html).

## Apereo Foundation Membership

The Apereo Foundation is a New Jersey non-stock, non-profit corporation, with members drawn from all walks of life and industry sectors on four continents. **Its mission is to help educational organizations deliver their mission by developing and sustaining open source software**. By becoming an Apereo Foundation member, you –

- **Ensure support for software you rely on**. Your membership dues work to ensure effective licensing, IPR management practices, infrastructure support, community coordination, outreach, and more.
- **Give your institution a say in the way Apereo is run, and how it sets priorities**. Your institution has a vote in elections for the Apereo Foundation Board, which provides strategic leadership for the foundation.
- **Are able to access programs such as the Apereo Incubation Program**. Have a software project you believe meets a higher education need? Apereo is the place to find partners and learn from others who've grown communities to sustain software.
- **Become part of a community of peers** - a global network of educational institutions working together to address common issues and solve common problems - with many opportunities to participate.

For more information about *organizational* membership dues and fees, [please see this page](https://www.apereo.org/content/apereo-membership). For 
information about *individual* membership programs, see [Friends of Apereo](https://www.apereo.org/friends).

## Paid/Commercial Support

Commercial support for CAS is provided by the following entities:

<style>
[data-bs-theme="dark"] {
  #fawnoosImage {
    content:url("https://github.com/apereo/cas/assets/1205228/2219a9fd-1f59-487a-910f-96f2a9f23a69");
  }
}
</style>

<table width="100%">
  <tr>
      <td>
        <a href="https://unicon.net/">
          <img id="uniconImage" valign="middle" width="220" src="https://user-images.githubusercontent.com/1205228/45105314-384b7b80-b149-11e8-9cae-085ab33a9e97.png">
        </a>
      </td>
    
      <td>
        <a href="https://fawnoos.com">
          <img id="fawnoosImage" valign="middle" width="300" style="margin-top:6px" src="https://user-images.githubusercontent.com/1205228/104875808-7426ba80-596b-11eb-8fa3-ac9376a8abb1.png">
        </a>
      </td>
    
      <td>
        <a href="https://www.casinthecloud.com/">
          <img id="casInTheCloudImage" valign="middle" src="https://user-images.githubusercontent.com/1205228/47741421-7f5c7580-dc8f-11e8-95cc-d16f41ab52c0.png">
        </a>
      </td>
    
      <td>
        <a href="https://www.tirasa.net/en">
          <img id="tirasaImage" valign="middle" width="180" src="https://user-images.githubusercontent.com/1205228/54271312-81d4b300-453e-11e9-82fe-6749b09a6446.png">
        </a>
      </td>
  </tr>
</table>

## Free/Community Support

Please take the following steps to obtain support from the CAS user community.

<div class="alert alert-info">:information_source: <strong>Community Etiquette</strong><p>Remember that activity on the mailing lists and all other support channels
is entirely voluntary. There are no SLAs. There are no guarantees. You may opt into professional support agreements with 
Apereo commercial service providers if that is unacceptable. Also unless explicitly asked, please <b>avoid</b> contacting individual project members directly.</p></div>

### Chat Rooms

Apereo has an official [Slack chat workspace](https://apereo.slack.com) where you may find a `#cas` 
channel. The sign-up page is [available here](https://apereo.slack.com/signup). A 
specific `cas` tag is also available for StackOverflow.

### Mailing Lists

The CAS community discussion mailing list is a moderate traffic list where questions are typically answered on the
order of minutes and typically resolved within a couple days. CAS developers monitor the list and frequently
participate in discussion. See the [Mailing Lists](Mailing-Lists.html) page for subscription and etiquette.

## Conferences

The [Apereo Foundation](http://www.apereo.org/) (formerly Jasig) offers a number of conferences that provide
presentations and training on a number of software products, including CAS, that are relevant to Higher Education.
Conferences are an excellent venue for strengthening ties to the larger CAS community and related open source software
ecosystem.
