package org.apereo.cas.util;

import module java.base;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import lombok.val;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletResponse;
import tools.jackson.databind.ObjectMapper;
import static org.junit.jupiter.api.Assertions.*;

/**
 * This is {@link JsonUtilsTests}.
 *
 * @author Misagh Moayyed
 * @since 6.1.0
 */
@Tag("Utility")
class JsonUtilsTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder()
        .defaultTypingEnabled(false).build().toObjectMapper();

    @Test
    void verifyRender() {
        val response = new MockHttpServletResponse();
        JsonUtils.render(response);
        assertEquals(HttpStatus.OK.value(), response.getStatus());
    }

    @Test
    void verifyRenderException() {
        val response = new MockHttpServletResponse();
        JsonUtils.renderException(new RuntimeException("error"), response);
        assertEquals(HttpStatus.BAD_REQUEST.value(), response.getStatus());
    }

    @Test
    void verifyRenderModel() throws Throwable {
        val response = new MockHttpServletResponse();
        val model = Map.of("key", List.of("one", "two"));
        JsonUtils.render(model, response);
        assertEquals(HttpStatus.OK.value(), response.getStatus());
        val content = response.getContentAsString();
        assertNotNull(MAPPER.readValue(content, Map.class));
    }
}
