package org.apereo.cas.util.crypto;

import module java.base;
import lombok.val;
import org.jose4j.keys.RsaKeyUtil;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.core.io.ClassPathResource;
import static org.junit.jupiter.api.Assertions.*;

/**
 * This is {@link PublicKeyFactoryBeanTests}.
 *
 * @author Misagh Moayyed
 * @since 6.1.0
 */
@Tag("X509")
class PublicKeyFactoryBeanTests {

    @Test
    void verifyOperation() throws Throwable {
        val factory = new PublicKeyFactoryBean(new ClassPathResource("publickey.pem"), RsaKeyUtil.RSA);
        factory.setSingleton(false);
        val object = factory.getObject();
        assertNotNull(object);
    }

    @Test
    void verifyFails() {
        val factory = new PublicKeyFactoryBean(new ClassPathResource("badkey.pem"), RsaKeyUtil.RSA);
        factory.setSingleton(false);
        assertNull(factory.toCipher());
    }
}
