package org.apereo.cas.util.feature;

import module java.base;
import lombok.RequiredArgsConstructor;
import lombok.val;
import org.jooq.lambda.Unchecked;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.PropertiesLoaderUtils;

/**
 * This is {@link DefaultCasRuntimeModuleLoader}.
 *
 * @author Misagh Moayyed
 * @since 6.5.0
 */
@RequiredArgsConstructor
public class DefaultCasRuntimeModuleLoader implements CasRuntimeModuleLoader {
    @Override
    public List<CasRuntimeModule> load() throws Exception {
        val loader = new PathMatchingResourcePatternResolver(getClass().getClassLoader());
        return Arrays.stream(loader.getResources("classpath*:/git.properties"))
            .map(Unchecked.function(PropertiesLoaderUtils::loadProperties))
            .filter(props -> props.containsKey("project.name"))
            .map(props -> CasRuntimeModule.builder()
                .name(props.get("project.name").toString())
                .version(props.get("project.version").toString())
                .description(props.get("project.description").toString())
                .build())
            .sorted(Comparator.comparing(CasRuntimeModule::getName))
            .collect(Collectors.toList());
    }
}
