package org.apereo.cas.util;

import module java.base;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * This is {@link PublisherIdentifier}. Allows one to declare strings as Spring beans.
 *
 * @author Misagh Moayyed
 * @since 5.2.0
 */
@Getter
@Setter
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS)
@ToString
public class PublisherIdentifier implements Serializable {
    /**
     * Default bean name for publisher identifier.
     */
    public static final String DEFAULT_BEAN_NAME = "messageQueueTicketRegistryIdentifier";

    @Serial
    private static final long serialVersionUID = -2216572507148074902L;

    private String id = UUID.randomUUID().toString();
}
