package org.apereo.cas.ticket.proxy.support;

import module java.base;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import lombok.val;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

/**
 * @author Scott Battaglia
 * @since 3.0.0
 */
@Tag("AuthenticationHandler")
class Cas10ProxyHandlerTests {

    private final ProxyHandler proxyHandler = new Cas10ProxyHandler();

    @Test
    void verifyNoCredentialsOrProxy() throws Throwable {
        assertNull(this.proxyHandler.handle(null, null));
    }

    @Test
    void verifyCredentialsAndProxy() throws Throwable {
        val proxyGrantingTicket = mock(TicketGrantingTicket.class);
        when(proxyGrantingTicket.getId()).thenReturn("proxyGrantingTicket");
        assertNull(this.proxyHandler.handle(
            CoreAuthenticationTestUtils.getCredentialsWithSameUsernameAndPassword(), proxyGrantingTicket));
    }
}
