package org.apereo.cas.ticket.expiration;

import module java.base;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.apereo.cas.util.serialization.SerializationUtils;
import lombok.val;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import tools.jackson.databind.ObjectMapper;
import static org.junit.jupiter.api.Assertions.*;

/**
 * Test cases for {@link NeverExpiresExpirationPolicy}.
 *
 * @author Misagh Moayyed
 * @since 4.1
 */
@Tag("ExpirationPolicy")
class NeverExpiresExpirationPolicyTests {

    private static final File JSON_FILE = new File(FileUtils.getTempDirectoryPath(), "neverExpiresExpirationPolicy.json");

    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder()
        .defaultTypingEnabled(true).build().toObjectMapper();

    @Test
    void verifySerializeANeverExpiresExpirationPolicyToJson() throws IOException {
        val policyWritten = NeverExpiresExpirationPolicy.INSTANCE;
        MAPPER.writeValue(JSON_FILE, policyWritten);
        val policyRead = MAPPER.readValue(JSON_FILE, NeverExpiresExpirationPolicy.class);
        assertEquals(policyWritten, policyRead);
    }

    @Test
    void verifySerialization() {
        val policyWritten = new NeverExpiresExpirationPolicy();
        val result = SerializationUtils.serialize(policyWritten);
        val policyRead = SerializationUtils.deserialize(result, NeverExpiresExpirationPolicy.class);
        assertEquals(policyWritten, policyRead);
    }
}
