package org.apereo.cas.ticket.expiration;

import module java.base;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.TicketGrantingTicketAwareTicket;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.val;

/**
 * This is an {@link AbstractCasExpirationPolicy}
 * that serves as the root parent for all CAS expiration policies
 * and exposes a few internal helper methods to children can access
 * to objects like the request, etc.
 *
 * @author Misagh Moayyed
 * @since 4.1
 */
@Getter
@Setter
@ToString
@EqualsAndHashCode
public abstract class AbstractCasExpirationPolicy implements ExpirationPolicy {

    @Serial
    private static final long serialVersionUID = 8042104336580063690L;

    private String name;

    private Clock clock = Clock.systemUTC();

    protected AbstractCasExpirationPolicy() {
        this.name = this.getClass().getSimpleName() + '-' + UUID.randomUUID();
    }

    @Override
    public boolean isExpired(final TicketGrantingTicketAwareTicket ticketState) {
        val tgt = ticketState.getTicketGrantingTicket();
        return tgt != null && tgt.isExpired();
    }
}
