package org.apereo.cas.ticket;

import module java.base;
import org.apereo.cas.authentication.principal.Service;
import lombok.Getter;
import org.jspecify.annotations.Nullable;

/**
 * Exception to alert that there was an error validating the ticket.
 *
 * @author Scott Battaglia
 * @since 4.2.0
 */
@Getter
public abstract class AbstractTicketValidationException extends AbstractTicketException {
    /**
     * The code description.
     */
    protected static final String CODE = "INVALID_TICKET";

    @Serial
    private static final long serialVersionUID = 3257004341537093175L;

    @Nullable
    private final Service service;

    /**
     * Constructs a AbstractTicketValidationException with the default exception code
     * and the original exception that was thrown.
     *
     * @param service original service
     */
    protected AbstractTicketValidationException(final Service service) {
        this(CODE, service);
    }

    protected AbstractTicketValidationException(final String code, @Nullable final Service service) {
        super(code);
        this.service = service;
    }

    protected AbstractTicketValidationException(final String code, final String msg,
                                                final List<Object> args, @Nullable final Service service) {
        super(code, msg, args);
        this.service = service;
    }

    protected AbstractTicketValidationException(final String code, final Throwable throwable,
                                                final List<Object> args, @Nullable final Service service) {
        super(code, throwable, args);
        this.service = service;
    }
}
