package org.apereo.cas.services;

import module java.base;
import lombok.val;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.context.support.StaticApplicationContext;
import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

/**
 * @author Misagh Moayyed
 * @since 5.2.0
 */
@Tag("RegisteredService")
class DefaultServiceRegistryInitializerTests {

    private static RegisteredService newService() {
        val service = mock(RegisteredService.class);
        when(service.getServiceId()).thenReturn("^https?://.*");
        when(service.getName()).thenReturn("Test");
        when(service.getDescription()).thenReturn("Test");
        return service;
    }

    @Test
    void ensureInitFromJsonDoesNotCreateDuplicates() {
        val initialService = newService();

        val servicesManager = mock(ServicesManager.class);
        val jsonServiceRegistry = mock(ServiceRegistry.class);
        when(jsonServiceRegistry.load()).thenReturn(List.of(initialService));

        val appCtx = new StaticApplicationContext();
        appCtx.refresh();

        val serviceRegistry = new InMemoryServiceRegistry(appCtx);
        val serviceRegistryInitializer = new DefaultServiceRegistryInitializer(jsonServiceRegistry,
            new DefaultChainingServiceRegistry(appCtx, List.of(serviceRegistry)),
            servicesManager);
        serviceRegistryInitializer.initialize();
        assertEquals(1, serviceRegistry.size());

        val initialService2 = newService();
        when(jsonServiceRegistry.load()).thenReturn(List.of(initialService2));

        serviceRegistryInitializer.initialize();
        assertEquals(1, serviceRegistry.size());
    }
}
