package org.apereo.cas.services;

import module java.base;
import org.apereo.cas.authentication.AuthenticationPolicy;
import org.apereo.cas.authentication.policy.RequiredAuthenticationHandlerAuthenticationPolicy;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import lombok.val;

/**
 * This is {@link AllowedAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria}.
 *
 * @author Misagh Moayyed
 * @since 6.3.0
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS)
@ToString
@Getter
@EqualsAndHashCode
@Setter
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class AllowedAuthenticationHandlersRegisteredServiceAuthenticationPolicyCriteria implements RegisteredServiceAuthenticationPolicyCriteria {
    @Serial
    private static final long serialVersionUID = -7298017804877275864L;

    private boolean tryAll;
    
    @Override
    public AuthenticationPolicy toAuthenticationPolicy(final RegisteredService registeredService) {
        val handlers = registeredService.getAuthenticationPolicy().getRequiredAuthenticationHandlers();
        return new RequiredAuthenticationHandlerAuthenticationPolicy(handlers, this.tryAll);
    }
}
