package org.apereo.cas.services.support;

import module java.base;
import com.fasterxml.jackson.annotation.JsonInclude;
import lombok.extern.slf4j.Slf4j;
import lombok.val;

/**
 * A filtering policy that selectively applies patterns to attributes mapped in the config.
 * If an attribute is mapped, it's only allowed to be released if it does not match the linked pattern.
 * If an attribute is not mapped, it may optionally be excluded from the released set of attributes.
 *
 * @author Misagh Moayyed
 * @since 5.1.0
 */
@Slf4j
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class RegisteredServiceReverseMappedRegexAttributeFilter extends RegisteredServiceMappedRegexAttributeFilter {

    @Serial
    private static final long serialVersionUID = 852145306984610128L;

    @Override
    protected List<Object> filterAttributeValuesByPattern(final Set<Object> attributeValues, final Pattern pattern) {
        return attributeValues
            .stream()
            .filter(v -> {
                LOGGER.debug("Matching attribute value [{}] against pattern [{}]", v, pattern.pattern());
                val matcher = pattern.matcher(v.toString());
                if (isCompleteMatch()) {
                    return !matcher.matches();
                }
                return !matcher.find();
            })
            .collect(Collectors.toList());
    }
}
