package org.apereo.cas.services;

import module java.base;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;

/**
 * This is {@link DefaultRegisteredServiceDelegatedAuthenticationPolicy}.
 *
 * @author Misagh Moayyed
 * @since 5.2.0
 */
@Slf4j
@ToString
@Getter
@Setter
@EqualsAndHashCode
@NoArgsConstructor
@Accessors(chain = true)
@JsonInclude(JsonInclude.Include.NON_DEFAULT)
public class DefaultRegisteredServiceDelegatedAuthenticationPolicy implements RegisteredServiceDelegatedAuthenticationPolicy {
    @Serial
    private static final long serialVersionUID = -784106970642770923L;

    @JsonSetter(nulls = Nulls.AS_EMPTY)
    private Collection<String> allowedProviders = new ArrayList<>();

    private boolean permitUndefined = true;

    private boolean exclusive;

    private String selectionStrategy;

    @Override
    @JsonIgnore
    public boolean isProviderAllowed(final String provider, final RegisteredService registeredService) {
        if (getAllowedProviders() == null || getAllowedProviders().isEmpty()) {
            LOGGER.warn("Registered service [{}] does not define any authorized/supported delegated authentication providers. "
                    + "It is STRONGLY recommended that you authorize and assign providers to the service definition. "
                    + "While just a warning for now, this behavior will be enforced by CAS in future versions.",
                registeredService.getName());
            return this.permitUndefined;
        }
        return getAllowedProviders().contains(provider);
    }
}
