package org.apereo.cas.notifications.sms;

import module java.base;
import org.apereo.cas.configuration.model.support.sms.SmsProperties;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import lombok.Builder;
import lombok.experimental.SuperBuilder;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * This is {@link SmsBodyBuilder}.
 *
 * @author Misagh Moayyed
 * @since 6.6.0
 */
@Slf4j
@SuperBuilder
public class SmsBodyBuilder implements Supplier<String> {
    private final SmsProperties properties;

    @Builder.Default
    private final Map<String, Object> parameters = new LinkedHashMap<>();

    @Override
    public String get() {
        if (StringUtils.isBlank(properties.getText())) {
            LOGGER.warn("No SMS text is defined");
            return StringUtils.EMPTY;
        }
        try {
            val templateFile = ResourceUtils.getResourceFrom(properties.getText());
            try (val is = templateFile.getInputStream()) {
                val contents = IOUtils.toString(is, StandardCharsets.UTF_8);
                return formatSmsBody(contents);
            }
        } catch (final Throwable e) {
            LOGGER.trace(e.getMessage(), e);
        }
        return formatSmsBody(properties.getText());
    }

    protected String formatSmsBody(final String contents) {
        return SpringExpressionLanguageValueResolver.getInstance().format(contents, parameters);
    }
}
