package org.apereo.cas.nativex;

import module java.base;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import lombok.val;
import org.apache.logging.log4j.core.async.AsyncLoggerContextSelector;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.servlet.View;
import java.lang.management.RuntimeMXBean;

/**
 * This is {@link CasCoreLoggingRuntimeHints}.
 *
 * @author Misagh Moayyed
 * @since 7.3.0
 */
public class CasCoreLoggingRuntimeHints implements CasRuntimeHintsRegistrar {
    @Override
    public void registerHints(final @NonNull RuntimeHints hints, final @Nullable ClassLoader classLoader) {
        val entries = List.<Class>of(
            AsyncLoggerContextSelector.class,
            RuntimeMXBean.class
        );
        registerReflectionHints(hints, entries);
        registerSpringProxyHints(hints, InitializingBean.class, View.class,
            BeanNameAware.class, ServletContextAware.class, ApplicationContextAware.class);
    }
}

