package org.apereo.cas.logging;

import module java.base;
import org.apereo.cas.util.app.ApplicationEntrypointInitializer;
import lombok.NoArgsConstructor;
import lombok.val;
import org.apache.commons.lang3.Strings;
import org.apache.logging.log4j.core.lookup.MainMapLookup;

/**
 * This is {@link Log4jInitialization}.
 *
 * @author Misagh Moayyed
 * @since 6.4.0
 */
@NoArgsConstructor
public class Log4jInitialization implements ApplicationEntrypointInitializer {
    @Override
    public ApplicationEntrypointInitializer initialize(final String[] mainArguments) {
        val args = Arrays.stream(mainArguments)
            .filter(arg -> arg.startsWith("--logging.level"))
            .map(arg -> Strings.CI.replace(arg, "=", " "))
            .toArray(String[]::new);
        MainMapLookup.setMainArguments(args);
        return this;
    }
}
