package org.apereo.cas.authentication.bypass;

import module java.base;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.services.RegisteredService;
import lombok.extern.slf4j.Slf4j;
import org.jspecify.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import jakarta.servlet.http.HttpServletRequest;

/**
 * Multifactor Bypass provider that will never allow MFA to execute and will always bypass.
 *
 * @author Misagh Moayyed
 * @since 7.0
 */
@Slf4j
public class AlwaysAllowMultifactorAuthenticationProviderBypassEvaluator extends BaseMultifactorAuthenticationProviderBypassEvaluator {
    @Serial
    private static final long serialVersionUID = -1433888418344342672L;

    public AlwaysAllowMultifactorAuthenticationProviderBypassEvaluator(final ApplicationContext applicationContext) {
        super(AlwaysAllowMultifactorAuthenticationProviderBypassEvaluator.class.getSimpleName(), applicationContext);
    }


    @Override
    public boolean shouldMultifactorAuthenticationProviderExecuteInternal(final Authentication authentication,
                                                                          @Nullable final RegisteredService registeredService,
                                                                          final MultifactorAuthenticationProvider provider,
                                                                          @Nullable final HttpServletRequest request) {
        LOGGER.debug("Provider [{}] will not allow multifactor authentication to execute", provider.getId());
        return false;
    }
}
