package org.apereo.cas.authentication.metadata;

import module java.base;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;


/**
 * This is {@link CacheCredentialsCipherExecutor}.
 *
 * @author Misagh Moayyed
 * @since 5.1.0
 */
public class CacheCredentialsCipherExecutor extends BaseStringCipherExecutor {

    public CacheCredentialsCipherExecutor(final String secretKeyEncryption,
                                          final String secretKeySigning,
                                          final String alg,
                                          final int signingKeySize,
                                          final int encryptionKeySize) {
        super(secretKeyEncryption, secretKeySigning, alg, signingKeySize, encryptionKeySize);
    }


    @Override
    public String getName() {
        return "Credential Caching & Clearpass";
    }

    @Override
    public String getEncryptionKeySetting() {
        return "cas.clearpass.crypto.encryption.key";
    }

    @Override
    public String getSigningKeySetting() {
        return "cas.clearpass.crypto.signing.key";
    }
}
