package org.apereo.cas.authentication.handler;

import module java.base;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerResolver;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.util.scripting.ExecutableCompiledScript;
import org.apereo.cas.util.scripting.ExecutableCompiledScriptFactory;
import lombok.Getter;
import lombok.Setter;
import lombok.val;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;

/**
 * This is {@link GroovyAuthenticationHandlerResolver}.
 *
 * @author Misagh Moayyed
 * @since 6.2.0
 */
@Getter
@Setter
public class GroovyAuthenticationHandlerResolver implements AuthenticationHandlerResolver, DisposableBean {
    private final ExecutableCompiledScript watchableScript;

    private final ServicesManager servicesManager;

    private int order;

    public GroovyAuthenticationHandlerResolver(final Resource groovyResource, final ServicesManager servicesManager) {
        this(groovyResource, servicesManager, Ordered.LOWEST_PRECEDENCE);
    }

    public GroovyAuthenticationHandlerResolver(final Resource groovyResource, final ServicesManager servicesManager, final int order) {
        this.order = order;
        this.servicesManager = servicesManager;
        val scriptFactory = ExecutableCompiledScriptFactory.getExecutableCompiledScriptFactory();
        this.watchableScript = scriptFactory.fromResource(groovyResource);
    }

    @Override
    public @Nullable Set<AuthenticationHandler> resolve(final Set<AuthenticationHandler> candidateHandlers,
                                                        final AuthenticationTransaction transaction) throws Throwable {
        val args = new Object[]{candidateHandlers, transaction, servicesManager, LOGGER};
        return watchableScript.execute(args, Set.class);
    }

    @Override

    public boolean supports(final Set<AuthenticationHandler> handlers, final AuthenticationTransaction transaction) throws Throwable {
        val args = new Object[]{handlers, transaction, servicesManager, LOGGER};
        return Boolean.TRUE.equals(watchableScript.execute("supports", Boolean.class, args));
    }

    @Override
    public void destroy() {
        this.watchableScript.close();
    }
}
