package org.apereo.cas.authentication.credential;

import module java.base;
import org.apereo.cas.authentication.MutableCredential;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.AllArgsConstructor;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * This is {@link BasicIdentifiableCredential}, a simple credential implementation
 * that is only recognized by its id. The id generally represents an authentication token
 * encrypted in some fashion.
 *
 * @author Misagh Moayyed
 * @since 4.2.0
 */
@ToString
@Getter
@Setter
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS)
@SuppressWarnings("NullAway.Init")
public class BasicIdentifiableCredential extends AbstractCredential implements MutableCredential {
    @Serial
    private static final long serialVersionUID = -700605020472810939L;

    @JsonProperty("id")
    private String id;
}
