const cas = require("../../cas.js");
const assert = require("assert");

(async () => {
    const browser = await cas.newBrowser(cas.browserOptions());
    try {
        const context = await browser.createBrowserContext();
        const page = await cas.newPage(context);
        const redirectUri = "https://localhost:9859/anything/cas";
        const url = `https://localhost:8443/cas/oidc/authorize?response_type=code&client_id=client&scope=${encodeURIComponent("openid profile email")}&redirect_uri=${redirectUri}`;

        await cas.goto(page, url);
        await cas.logPage(page);
        await cas.sleep(1000);
        await cas.loginWith(page);
        await cas.sleep(1000);
        if (await cas.isVisible(page, "#allow")) {
            await cas.click(page, "#allow");
            await cas.waitForNavigation(page);
        }

        const code = await cas.assertParameter(page, "code");
        await cas.log(`Current code is ${code}`);
        const accessTokenUrl = "https://localhost:8443/cas/oidc/token?grant_type=authorization_code"
            + `&client_id=client&client_secret=secret&redirect_uri=${redirectUri}&code=${code}`;

        const payload = await cas.doPost(accessTokenUrl, "", {
            "Content-Type": "application/json"
        }, (res) => res.data, (error) => {
            throw `Operation failed to obtain access token: ${error}`;
        });

        const decoded = await cas.decodeJwt(payload.id_token);
        assert(decoded.sub !== undefined);
        assert(decoded.client_id !== undefined);
        assert(decoded["preferred_username"] === "apereo-casuser");
        assert(decoded["email"] !== undefined);
        assert(decoded["family_name"] !== undefined);
        assert(decoded["given_name"] !== undefined);
        assert(decoded["name"] !== undefined);
        assert(decoded["org"]["apereo"]["cas"]["entity"] !== undefined);
        assert(decoded["container"]["name"] === "Alice");
        assert(decoded["container"]["email"] === "alice@example.com");
        assert(decoded["container"]["roles"].length === 2);
        assert(decoded["container"]["roles"].includes("admin"));
        assert(decoded["container"]["roles"].includes("editor"));

        await context.close();
    } finally {
        await cas.closeBrowser(browser);
    }
})();
