package org.apereo.cas.util.serialization;

import module java.base;
import org.springframework.core.Ordered;
import tools.jackson.databind.cfg.MapperBuilder;

/**
 * This is {@link JacksonObjectMapperCustomizer}.
 *
 * @author Misagh Moayyed
 * @since 6.6.0
 */
public interface JacksonObjectMapperCustomizer extends Ordered {
    
    /**
     * Get injectable values from this customer to ultimately
     * collect and stuff into the mapper itself.
     *
     * @return the map
     */
    default Map<String, ?> getInjectableValues() {
        return new HashMap<>();
    }

    /**
     * Customize the mapper.
     *
     * @param objectMapper the object mapper
     */
    default MapperBuilder customize(final MapperBuilder<?, ?> objectMapper) {
        return objectMapper;
    }

    @Override
    default int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }

    /**
     * Mapped injectable values.
     *
     * @param injectables the injectables
     * @return the jackson object mapper customizer
     */
    static JacksonObjectMapperCustomizer mappedInjectableValues(final Map<String, ?> injectables) {
        return new JacksonObjectMapperCustomizer() {
            @Override
            public Map<String, ?> getInjectableValues() {
                return injectables;
            }
        };
    }
}
