package org.apereo.cas.authentication.principal;

import module java.base;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import lombok.val;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

/**
 * This is {@link RegisteredServicePrincipalAttributesRepositoryTests}.
 *
 * @author Misagh Moayyed
 * @since 6.3.0
 */
@Tag("RegisteredService")
class RegisteredServicePrincipalAttributesRepositoryTests {
    @Test
    void verifyOperation() {
        val policy = mock(RegisteredServicePrincipalAttributesRepository.class);
        doCallRealMethod().when(policy).update(any(), any(), any());
        assertDoesNotThrow(() -> policy.update(UUID.randomUUID().toString(),
            Map.of(), mock(RegisteredServiceAttributeReleasePolicyContext.class)));
    }
}
