package org.apereo.cas.services;

import module java.base;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

/**
 * This is {@link RegisteredServiceServiceTicketExpirationPolicy}.
 * This contract allows applications registered with CAS to define
 * an expiration policy for service tickets as to override
 * the default timeouts and settings applied globally.
 *
 * @author Misagh Moayyed
 * @since 6.1.0
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.CLASS)
public interface RegisteredServiceServiceTicketExpirationPolicy extends Serializable {
    /**
     * Undefined registered service ticket expiration policy.
     *
     * @return the registered service ticket expiration policy
     */
    static RegisteredServiceServiceTicketExpirationPolicy undefined() {
        return new RegisteredServiceServiceTicketExpirationPolicy() {
            @Serial
            private static final long serialVersionUID = -6204076273553630977L;

            @Override
            public long getNumberOfUses() {
                return Long.MIN_VALUE;
            }

            @Override
            public String getTimeToLive() {
                return null;
            }
        };
    }

    /**
     * Gets number of times this ticket can be used.
     *
     * @return the number of uses
     */
    long getNumberOfUses();

    /**
     * Get the TTL of this ticket, in seconds.
     *
     * @return the time to live
     */
    String getTimeToLive();
}
