package org.apereo.cas.util.scripting;

import module java.base;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;

/**
 * This is {@link ExecutableCompiledScript}.
 *
 * @author Misagh Moayyed
 * @since 6.1.0
 */
public interface ExecutableCompiledScript extends AutoCloseable {

    /**
     * Execute t.
     *
     * @param <T>   the type parameter
     * @param args  the args
     * @param clazz the clazz
     * @return the t
     */
    <T> @Nullable T execute(Object[] args, Class<T> clazz) throws Throwable;

    /**
     * Execute.
     *
     * @param args the args
     */
    void execute(Object[] args) throws Throwable;

    /**
     * Execute t.
     *
     * @param <T>         the type parameter
     * @param args        the args
     * @param clazz       the clazz
     * @param failOnError the fail on error
     * @return the t
     */
    <T> @Nullable T execute(Object[] args, Class<T> clazz, boolean failOnError);

    /**
     * Execute t.
     *
     * @param <T>        the type parameter
     * @param methodName the method name
     * @param clazz      the clazz
     * @param args       the args
     * @return the t
     */
    <T> @Nullable T execute(String methodName, Class<T> clazz, Object... args) throws Throwable;

    /**
     * Sets binding.
     *
     * @param args the args
     */
    default void setBinding(final Map<String, Object> args) {
    }

    @Override
    default void close() {
    }

    /**
     * Sets fail on error.
     *
     * @param failOnError the fail on error
     * @return the fail on error
     */
    default ExecutableCompiledScript setFailOnError(final boolean failOnError) {
        return this;
    }

    /**
     * Gets compiled script.
     *
     * @return the compiled script
     */
    Object getCompiledScript();

    /**
     * Gets resource.
     *
     * @return the resource
     */
    Resource getResource();
}
