package org.apereo.cas.logout;

import module java.base;
import org.apereo.cas.logout.slo.SingleLogoutServiceMessageHandler;

/**
 * This is {@link LogoutExecutionPlan} that describes how various CAS modules
 * must respond to the CAS logout events. A simple example of this may be OAuth
 * or OpenID Connect where Access Tokens and Refresh Tokens may need to be cleaned up
 * once the associated TGT is perhaps removed.
 *
 * @author Misagh Moayyed
 * @since 5.1.0
 */
public interface LogoutExecutionPlan {
    /**
     * Default implementation bean name.
     */
    String BEAN_NAME = "logoutExecutionPlan";

    /**
     * Register logout handler.
     *
     * @param handler the handler
     */
    default void registerLogoutPostProcessor(final LogoutPostProcessor handler) {
    }

    /**
     * Register single logout service message handler.
     *
     * @param handler the handler
     */
    default void registerSingleLogoutServiceMessageHandler(final SingleLogoutServiceMessageHandler handler) {
    }

    /**
     * Register logout redirection strategy.
     *
     * @param strategy the strategy
     */
    default void registerLogoutRedirectionStrategy(final LogoutRedirectionStrategy strategy) {
    }

    /**
     * Gets logout handlers.
     *
     * @return the logout handlers
     */
    default Collection<LogoutPostProcessor> getLogoutPostProcessors() {
        return new ArrayList<>();
    }

    default Collection<LogoutRedirectionStrategy> getLogoutRedirectionStrategies() {
        return new ArrayList<>();
    }

    /**
     * Gets single logout service message handlers.
     *
     * @return the single logout service message handlers
     */
    default Collection<SingleLogoutServiceMessageHandler> getSingleLogoutServiceMessageHandlers() {
        return new ArrayList<>();
    }
}
