package org.apereo.cas.support.events.config;

import module java.base;
import org.apereo.cas.support.events.AbstractCasEvent;
import lombok.Getter;
import lombok.ToString;
import org.apereo.inspektr.common.web.ClientInfo;

/**
 * This is {@link CasConfigurationCreatedEvent}.
 *
 * @author Misagh Moayyed
 * @since 5.1.0
 */
@ToString(callSuper = true)
@Getter
public class CasConfigurationCreatedEvent extends AbstractCasEvent {

    @Serial
    private static final long serialVersionUID = -9038763901650896455L;

    private final transient Path file;

    public CasConfigurationCreatedEvent(final Object source, final Path file, final ClientInfo clientInfo) {
        super(source, clientInfo);
        this.file = file;
    }
}
