package org.apereo.cas.configuration.model.support.apn;

import module java.base;
import org.apereo.cas.configuration.model.SpringResourceProperties;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

/**
 * This is {@link APNMessagingProperties}.
 *
 * @author Misagh Moayyed
 * @since 6.3.0
 */
@Getter
@Setter
@RequiresModule(name = "cas-server-support-notifications-apn")
@Accessors(chain = true)
public class APNMessagingProperties implements Serializable {
    @Serial
    private static final long serialVersionUID = -2179682641899738092L;

    /**
     * Path to the authentication token signing key, specified as a text file (with a .p8 file extension).
     * You need an APNs authentication token signing key to generate the tokens that your server uses.
     * You request this key from your developer account on developer.apple.com
     */
    @NestedConfigurationProperty
    @RequiredProperty
    private SpringResourceProperties authenticationKey;

    /**
     * The principal attribute name
     * that contains the registration token for the user.
     * Registration tokens that are provided by clients during the handshake process
     * should be stored on the server, and made available to CAS
     * as a principal attribute.
     */
    @RequiredProperty
    private String registrationTokenAttributeName;
    
    /**
     * The APN server to use for push notifications.
     * Supported values are {@code production, development}.
     */
    private String server = "production";

    /**
     * A Team ID is a unique 10-character string generated by Apple that's assigned to your team. You'll need
     * to provide your Team ID for certain activities, such as transferring your
     * app to another developer in App Store Connect.
     * As part of the authentication process, APNs relates a team ID and
     * associated bundle IDs to a connection on the first push.
     */
    @RequiredProperty
    private String teamId;

    /**
     * The key ID of the authentication key.
     */
    @RequiredProperty
    private String keyId;

    /**
     * The topic to use for push notifications.
     * This is typically the bundle ID of your app.
     */
    @RequiredProperty
    private String topic;
}
