package org.apereo.cas.configuration.model.core.rest;

import module java.base;
import org.apereo.cas.configuration.support.RequiresModule;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * This is {@link RestX509Properties}.
 *
 * @author Misagh Moayyed
 * @since 5.0.0
 */
@RequiresModule(name = "cas-server-support-rest-x509")
@Getter
@Setter
@Accessors(chain = true)
public class RestX509Properties implements Serializable {

    @Serial
    private static final long serialVersionUID = -1833117478273171342L;

    /**
     * Flag that enables {@link java.security.cert.X509Certificate}
     * extraction from the request headers
     * for authentication.
     */
    private boolean headerAuth = true;

    /**
     * Flag that enables {@link java.security.cert.X509Certificate}
     * extraction from the request body for authentication.
     */
    private boolean bodyAuth;

    /**
     * Flag that enables TLS client {@link java.security.cert.X509Certificate}
     * extraction from the servlet container for authentication.
     */
    private boolean tlsClientAuth;
}
