package org.apereo.cas.configuration.model.core.events;

import module java.base;
import org.apereo.cas.configuration.model.support.jpa.AbstractJpaProperties;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * This is {@link JpaEventsProperties}.
 *
 * @author Misagh Moayyed
 * @since 6.3.0
 */
@RequiresModule(name = "cas-server-support-events-jpa")
@Getter
@Setter
@Accessors(chain = true)
public class JpaEventsProperties extends AbstractJpaProperties {
    @Serial
    private static final long serialVersionUID = 7647381223153797806L;

    /**
     * Whether capturing events via JPA is enabled.
     */
    @RequiredProperty
    private boolean enabled = true;
}
