package org.apereo.cas.configuration.model.core.authentication;

import module java.base;
import org.apereo.cas.configuration.support.RegularExpressionCapable;
import org.apereo.cas.configuration.support.RequiresModule;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * This is {@link AdaptiveAuthenticationPolicyProperties}.
 *
 * @author Misagh Moayyed
 * @since 5.0.0
 */
@RequiresModule(name = "cas-server-core-authentication", automated = true)
@Getter
@Setter
@Accessors(chain = true)
public class AdaptiveAuthenticationPolicyProperties implements Serializable {

    @Serial
    private static final long serialVersionUID = -1840174229142982880L;

    /**
     * Comma-separated list of strings representing countries to be
     * rejected from participating in authentication transactions.
     */
    private String rejectCountries;

    /**
     * Comma-separated list of strings representing browser user agents
     * to be rejected from participating in authentication transactions.
     */
    private String rejectBrowsers;

    /**
     * Comma-separated list of strings representing IP addresses to
     * be rejected from participating in authentication transactions.
     */
    private String rejectIpAddresses;

    /**
     * A map of ({@code mfaProviderId -> adaptiveRegexPattern}) that tells
     * CAS when to trigger an MFA authentication transaction.
     * <p>
     * This property binds a valid mfa provider to an adaptive regex
     * pattern representing either IP address, user-agent or geolocation.
     * When either of those collected pieces of adaptive data matches
     * configured regex pattern during authentication event,
     * an MFA authentication transaction is triggered for an
     * MFA provider represented by the map's key.
     * </p>
     */
    @RegularExpressionCapable
    private Map<String, String> requireMultifactor = new HashMap<>();

    /**
     * This property binds a valid mfa provider to a collection of rules that deal with triggering mfa
     * based on that provider based on properties of date/time. One may want to force mfa during weekends,
     * after hours, etc and the ruleset provides a modest configuration set where time can also be treated as trigger.
     */
    private List<TimeBasedAuthenticationProperties> requireTimedMultifactor = new ArrayList<>();
}
