package org.apereo.cas.audit;
import module java.base;

/**
 * This is {@link AuditActionResolvers}.
 *
 * @author Misagh Moayyed
 * @since 6.4.0
 */
public interface AuditActionResolvers {
    /**
     * Action resolver id {@code SAML2_METADATA_RESOLUTION_ACTION_RESOLVER}.
     */
    String SAML2_METADATA_RESOLUTION_ACTION_RESOLVER = "SAML2_METADATA_RESOLUTION_ACTION_RESOLVER";
    /**
     * Action resolver id {@code REQUEST_FORGOT_USERNAME_ACTION_RESOLVER}.
     */
    String REQUEST_FORGOT_USERNAME_ACTION_RESOLVER = "REQUEST_FORGOT_USERNAME_ACTION_RESOLVER";

    /**
     * Action resolver id {@code DELEGATED_CLIENT_ACTION_RESOLVER}.
     */
    String DELEGATED_CLIENT_ACTION_RESOLVER = "DELEGATED_CLIENT_ACTION_RESOLVER";

    /**
     * Action resolver id {@code SAVE_CONSENT_ACTION_RESOLVER}.
     */
    String SAVE_CONSENT_ACTION_RESOLVER = "SAVE_CONSENT_ACTION_RESOLVER";

    /**
     * Action resolver id {@code VERIFY_CONSENT_ACTION_RESOLVER}.
     */
    String VERIFY_CONSENT_ACTION_RESOLVER = "VERIFY_CONSENT_ACTION_RESOLVER";

    /**
     * Action resolver id {@code ADAPTIVE_RISKY_AUTHENTICATION_ACTION_RESOLVER}.
     */
    String ADAPTIVE_RISKY_AUTHENTICATION_ACTION_RESOLVER = "ADAPTIVE_RISKY_AUTHENTICATION_ACTION_RESOLVER";

    /**
     * Action resolver id {@code AUP_VERIFY_ACTION_RESOLVER}.
     */
    String AUP_VERIFY_ACTION_RESOLVER = "AUP_VERIFY_ACTION_RESOLVER";
    /**
     * Action resolver id {@code AUP_SUBMIT_ACTION_RESOLVER}.
     */
    String AUP_SUBMIT_ACTION_RESOLVER = "AUP_SUBMIT_ACTION_RESOLVER";
    /**
     * Action resolver id {@code CHANGE_PASSWORD_ACTION_RESOLVER}.
     */
    String CHANGE_PASSWORD_ACTION_RESOLVER = "CHANGE_PASSWORD_ACTION_RESOLVER";
    /**
     * Action resolver id {@code REQUEST_CHANGE_PASSWORD_ACTION_RESOLVER}.
     */
    String REQUEST_CHANGE_PASSWORD_ACTION_RESOLVER = "REQUEST_CHANGE_PASSWORD_ACTION_RESOLVER";

    /**
     * Action resolver id {@code REST_API_TICKET_GRANTING_TICKET_ACTION_RESOLVER}.
     */
    String REST_API_TICKET_GRANTING_TICKET_ACTION_RESOLVER = "REST_API_TICKET_GRANTING_TICKET_ACTION_RESOLVER";
    /**
     * Action resolver id {@code REST_API_SERVICE_TICKET_ACTION_RESOLVER}.
     */
    String REST_API_SERVICE_TICKET_ACTION_RESOLVER = "REST_API_SERVICE_TICKET_ACTION_RESOLVER";

    /**
     * Action resolver id {@code SAML2_RESPONSE_ACTION_RESOLVER}.
     */
    String SAML2_RESPONSE_ACTION_RESOLVER = "SAML2_RESPONSE_ACTION_RESOLVER";
    /**
     * Action resolver id {@code SAML2_REQUEST_ACTION_RESOLVER}.
     */
    String SAML2_REQUEST_ACTION_RESOLVER = "SAML2_REQUEST_ACTION_RESOLVER";

    /**
     * Action resolver id {@code TRUSTED_AUTHENTICATION_ACTION_RESOLVER}.
     */
    String TRUSTED_AUTHENTICATION_ACTION_RESOLVER = "TRUSTED_AUTHENTICATION_ACTION_RESOLVER";
    /**
     * Action resolver id {@code MULTIFACTOR_AUTHENTICATION_BYPASS_ACTION_RESOLVER}.
     */
    String MULTIFACTOR_AUTHENTICATION_BYPASS_ACTION_RESOLVER = "MULTIFACTOR_AUTHENTICATION_BYPASS_ACTION_RESOLVER";
    /**
     * Action resolver id {@code SURROGATE_AUTHENTICATION_ELIGIBILITY_VERIFICATION_ACTION_RESOLVER}.
     */
    String SURROGATE_AUTHENTICATION_ELIGIBILITY_VERIFICATION_ACTION_RESOLVER = "SURROGATE_AUTHENTICATION_ELIGIBILITY_VERIFICATION_ACTION_RESOLVER";
    /**
     * Action resolver id {@code SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_ACTION_RESOLVER}.
     */
    String SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_ACTION_RESOLVER = "SURROGATE_AUTHENTICATION_ELIGIBILITY_SELECTION_ACTION_RESOLVER";
    /**
     * Action resolver id {@code OAUTH2_USER_PROFILE_ACTION_RESOLVER}.
     */
    String OAUTH2_USER_PROFILE_ACTION_RESOLVER = "OAUTH2_USER_PROFILE_ACTION_RESOLVER";
    /**
     * Action resolver id {@code OAUTH2_ACCESS_TOKEN_REQUEST_ACTION_RESOLVER}.
     */
    String OAUTH2_ACCESS_TOKEN_REQUEST_ACTION_RESOLVER = "OAUTH2_ACCESS_TOKEN_REQUEST_ACTION_RESOLVER";
    /**
     * Action resolver id {@code OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER}.
     */
    String OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER = "OAUTH2_ACCESS_TOKEN_RESPONSE_ACTION_RESOLVER";
    /**
     * Action resolver id {@code OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER}.
     */
    String OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER = "OAUTH2_AUTHORIZATION_RESPONSE_ACTION_RESOLVER";

    /**
     * Action resolver id {@code AUTHENTICATION_RESOLVER}.
     */
    String AUTHENTICATION_RESOLVER = "AUTHENTICATION_RESOLVER";
    /**
     * Action resolver id {@code SAVE_SERVICE_ACTION_RESOLVER}.
     */
    String SAVE_SERVICE_ACTION_RESOLVER = "SAVE_SERVICE_ACTION_RESOLVER";
    /**
     * Action resolver id {@code DELETE_SERVICE_ACTION_RESOLVER}.
     */
    String DELETE_SERVICE_ACTION_RESOLVER = "DELETE_SERVICE_ACTION_RESOLVER";
    /**
     * Action resolver id {@code DESTROY_TICKET_RESOLVER}.
     */
    String DESTROY_TICKET_RESOLVER = "DESTROY_TICKET_RESOLVER";
    /**
     * Action resolver id {@code DESTROY_PROXY_GRANTING_TICKET_RESOLVER}.
     */
    String DESTROY_PROXY_GRANTING_TICKET_RESOLVER = "DESTROY_PROXY_GRANTING_TICKET_RESOLVER";
    /**
     * Action resolver id {@code CREATE_PROXY_GRANTING_TICKET_RESOLVER}.
     */
    String CREATE_PROXY_GRANTING_TICKET_RESOLVER = "CREATE_PROXY_GRANTING_TICKET_RESOLVER";
    /**
     * Action resolver id {@code GRANT_SERVICE_TICKET_RESOLVER}.
     */
    String GRANT_SERVICE_TICKET_RESOLVER = "GRANT_SERVICE_TICKET_RESOLVER";
    /**
     * Action resolver id {@code GRANT_PROXY_TICKET_RESOLVER}.
     */
    String GRANT_PROXY_TICKET_RESOLVER = "GRANT_PROXY_TICKET_RESOLVER";
    /**
     * Action resolver id {@code CREATE_TICKET_GRANTING_TICKET_RESOLVER}.
     */
    String CREATE_TICKET_GRANTING_TICKET_RESOLVER = "CREATE_TICKET_GRANTING_TICKET_RESOLVER";
    /**
     * Action resolver id {@code AUTHENTICATION_EVENT_ACTION_RESOLVER}.
     */
    String AUTHENTICATION_EVENT_ACTION_RESOLVER = "AUTHENTICATION_EVENT_ACTION_RESOLVER";
    /**
     * Action resolver id {@code VALIDATE_SERVICE_TICKET_RESOLVER}.
     */
    String VALIDATE_SERVICE_TICKET_RESOLVER = "VALIDATE_SERVICE_TICKET_RESOLVER";

    /**
     * Action resolver id {@code VALIDATE_PROTOCOL_SPECIFICATION_RESOLVER}.
     */
    String VALIDATE_PROTOCOL_SPECIFICATION_RESOLVER = "VALIDATE_PROTOCOL_SPECIFICATION_RESOLVER";

    /**
     * Action resolver id {@code SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER}.
     */
    String SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER = "SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER";

    /**
     * Action resolver id {@code ACCOUNT_REGISTRATION_TOKEN_CREATION_ACTION_RESOLVER}.
     */
    String ACCOUNT_REGISTRATION_TOKEN_CREATION_ACTION_RESOLVER = "ACCOUNT_REGISTRATION_TOKEN_CREATION_ACTION_RESOLVER";
    /**
     * Action resolver id {@code ACCOUNT_REGISTRATION_TOKEN_VALIDATION_ACTION_RESOLVER}.
     */
    String ACCOUNT_REGISTRATION_TOKEN_VALIDATION_ACTION_RESOLVER = "ACCOUNT_REGISTRATION_TOKEN_VALIDATION_ACTION_RESOLVER";

    /**
     * Action resolver id {@code ACCOUNT_REGISTRATION_PROVISIONING_ACTION_RESOLVER}.
     */
    String ACCOUNT_REGISTRATION_PROVISIONING_ACTION_RESOLVER = "ACCOUNT_REGISTRATION_PROVISIONING_ACTION_RESOLVER";

    /**
     * Action resolver id {@code LOGOUT_ACTION_RESOLVER}.
     */
    String LOGOUT_ACTION_RESOLVER = "LOGOUT_ACTION_RESOLVER";
    /**
     * Action resolver id {@code OIDC_ID_TOKEN_ACTION_RESOLVER}.
     */
    String OIDC_ID_TOKEN_ACTION_RESOLVER = "OIDC_ID_TOKEN_ACTION_RESOLVER";
    /**
     * Action resolver id {@code OIDC_CIBA_RESPONSE_ACTION_RESOLVER}.
     */
    String OIDC_CIBA_RESPONSE_ACTION_RESOLVER = "OIDC_CIBA_RESPONSE_ACTION_RESOLVER";
}
