# Read Before Submissions

Thank you for your contributions to Apereo CAS.

When you publish the pull request, please check off relevant items below in the description of your pull request.

Please make sure you include the following:

- [ ] Brief description of changes applied
- [ ] Test cases for all modified changes, where applicable
- [ ] The same pull request targeted at the master branch, if applicable
- [ ] Any documentation on how to configure, test
- [ ] Any possible limitations, side effects, etc
- [ ] Reference any other pull requests that might be related

For more information, please see [this page](https://apereo.github.io/cas/developer/Contributor-Guidelines.html).

If your pull request targets a maintenance branch and is not directed at `master`, make sure you reference the pull request that
has already ported your changes forward to the `master` branch. You may do so by including the following in your pull request description:

```
master: https://github.com/apereo/cas/pull/$PR_NUMBER
```

# Remember

**DO NOT** keep this template as is when you submit. Please remove or adjust the description when you submit your pull request.

Please do not submit a pull request to ask questions, seek guidance or support. Use the designated mailing lists to discuss
ideas, feature requests and bug fixes. See [mailing lists](https://apereo.github.io/cas/Mailing-Lists.html).

Do not submit pull requests without tests that verify or reproduce your intended use case. The pull request will
most likely be automatically closed immediately, unless the change is extremely trivial. 

If your change-set introduces a new CAS feature or improvement, please consider starting discussion with the 
project to see if your patch can be accepted and maintained by project owners and maintainers. Unless your change is 
extremely trivial and has been through proper review and is sponsored by a project maintainer, please do not spend 
time modifying code and configuration in a proposed pull request.

For more information, please see [this page](https://apereo.github.io/cas/developer/Contributor-Guidelines.html).
