/*
 * Decompiled with CFR 0.152.
 */
package org.mitre.jose.jwk;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.IOUtils;
import org.mitre.jose.jwk.ECKeyMaker;
import org.mitre.jose.jwk.OctetSequenceKeyMaker;
import org.mitre.jose.jwk.RSAKeyMaker;

public class Launcher {
    private static Options options;

    public static void main(String[] args) {
        options = new Options();
        options.addOption("t", true, "Key Type, one of: " + KeyType.RSA.getValue() + ", " + KeyType.OCT.getValue() + ", " + KeyType.EC.getValue());
        options.addOption("s", true, "Key Size in bits, required for RSA and oct key types. Must be an integer divisible by 8");
        options.addOption("u", true, "Usage, one of: enc, sig (optional)");
        options.addOption("a", true, "Algorithm (optional)");
        options.addOption("i", true, "Key ID (optional), one will be generated if not defined");
        options.addOption("I", false, "Don't generate a Key ID if none defined");
        options.addOption("p", false, "Display public key separately");
        options.addOption("c", true, "Key Curve, required for EC key type. Must be one of " + ECKey.Curve.P_256 + ", " + ECKey.Curve.P_384 + ", " + ECKey.Curve.P_521);
        options.addOption("S", false, "Wrap the generated key in a KeySet");
        options.addOption("o", true, "Write output to file (will append to existing KeySet if -S is used), No Display of Key Material");
        PosixParser parser = new PosixParser();
        try {
            Integer keySize;
            CommandLine cmd = parser.parse(options, args);
            String kty = cmd.getOptionValue("t");
            String size = cmd.getOptionValue("s");
            String use = cmd.getOptionValue("u");
            String alg = cmd.getOptionValue("a");
            String kid = cmd.getOptionValue("i");
            String crv = cmd.getOptionValue("c");
            boolean keySet = cmd.hasOption("S");
            boolean pubKey = cmd.hasOption("p");
            boolean doNotGenerateKid = cmd.hasOption("I");
            String outFile = cmd.getOptionValue("o");
            if (kty == null) {
                Launcher.printUsageAndExit("Key type must be supplied.");
            }
            KeyType keyType = KeyType.parse(kty);
            KeyUse keyUse = null;
            if (use != null) {
                if (use.equals("sig")) {
                    keyUse = KeyUse.SIGNATURE;
                } else if (use.equals("enc")) {
                    keyUse = KeyUse.ENCRYPTION;
                } else {
                    Launcher.printUsageAndExit("Invalid key usage, must be 'sig' or 'enc', got " + use);
                }
            }
            if (Strings.isNullOrEmpty(kid)) {
                kid = doNotGenerateKid ? null : Launcher.generateKid(keyUse);
            }
            JWSAlgorithm keyAlg = null;
            if (!Strings.isNullOrEmpty(alg)) {
                keyAlg = JWSAlgorithm.parse(alg);
            }
            JWK jwk = null;
            if (keyType.equals(KeyType.RSA)) {
                if (Strings.isNullOrEmpty(size)) {
                    Launcher.printUsageAndExit("Key size (in bits) is required for key type " + keyType);
                }
                if ((keySize = Integer.decode(size)) % 8 != 0) {
                    Launcher.printUsageAndExit("Key size (in bits) must be divisible by 8, got " + keySize);
                }
                jwk = RSAKeyMaker.make(keySize, keyUse, keyAlg, kid);
            } else if (keyType.equals(KeyType.OCT)) {
                if (Strings.isNullOrEmpty(size)) {
                    Launcher.printUsageAndExit("Key size (in bits) is required for key type " + keyType);
                }
                if ((keySize = Integer.decode(size)) % 8 != 0) {
                    Launcher.printUsageAndExit("Key size (in bits) must be divisible by 8, got " + keySize);
                }
                jwk = OctetSequenceKeyMaker.make(keySize, keyUse, keyAlg, kid);
            } else if (keyType.equals(KeyType.EC)) {
                if (Strings.isNullOrEmpty(crv)) {
                    Launcher.printUsageAndExit("Curve is required for key type " + keyType);
                }
                ECKey.Curve keyCurve = ECKey.Curve.parse(crv);
                jwk = ECKeyMaker.make(keyCurve, keyUse, keyAlg, kid);
            } else {
                Launcher.printUsageAndExit("Unknown key type: " + keyType);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (outFile == null) {
                System.out.println("Full key:");
                Launcher.printKey(keySet, jwk, gson);
                if (pubKey) {
                    System.out.println();
                    JWK pub = jwk.toPublicJWK();
                    if (pub != null) {
                        System.out.println("Public key:");
                        Launcher.printKey(keySet, pub, gson);
                    } else {
                        System.out.println("No public key.");
                    }
                }
            } else {
                Launcher.writeKeyToFile(keySet, outFile, jwk, gson);
            }
        }
        catch (NumberFormatException e) {
            Launcher.printUsageAndExit("Invalid key size: " + e.getMessage());
        }
        catch (ParseException e) {
            Launcher.printUsageAndExit("Failed to parse arguments: " + e.getMessage());
        }
        catch (java.text.ParseException e) {
            Launcher.printUsageAndExit("Could not parse existing KeySet: " + e.getMessage());
        }
        catch (IOException e) {
            Launcher.printUsageAndExit("Could not read existing KeySet: " + e.getMessage());
        }
    }

    private static String generateKid(KeyUse keyUse) {
        String prefix = keyUse == null ? "" : keyUse.identifier();
        return prefix + System.currentTimeMillis() / 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeKeyToFile(boolean keySet, String outFile, JWK jwk, Gson gson) throws IOException, java.text.ParseException {
        JsonElement json;
        File output = new File(outFile);
        if (keySet) {
            List existingKeys = output.exists() ? JWKSet.load(output).getKeys() : Collections.emptyList();
            ArrayList<JWK> jwkList = new ArrayList<JWK>(existingKeys);
            jwkList.add(jwk);
            JWKSet jwkSet = new JWKSet(jwkList);
            json = new JsonParser().parse(jwkSet.toJSONObject(false).toJSONString());
        } else {
            json = new JsonParser().parse(jwk.toJSONString());
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(output);
            IOUtils.write(gson.toJson(json), (OutputStream)os);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(os);
            throw throwable;
        }
        IOUtils.closeQuietly(os);
    }

    private static void printKey(boolean keySet, JWK jwk, Gson gson) {
        if (keySet) {
            JWKSet jwkSet = new JWKSet(jwk);
            JsonElement json = new JsonParser().parse(jwkSet.toJSONObject(false).toJSONString());
            System.out.println(gson.toJson(json));
        } else {
            JsonElement json = new JsonParser().parse(jwk.toJSONString());
            System.out.println(gson.toJson(json));
        }
    }

    private static void printUsageAndExit(String message) {
        if (message != null) {
            System.err.println(message);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -jar json-web-key-generator.jar -t <keyType> [options]", options);
        System.exit(1);
    }
}

