/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.versions.matcher;

import org.hotswap.agent.annotation.Maven;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.spring.util.PatternMatchUtils;
import org.hotswap.agent.util.spring.util.StringUtils;
import org.hotswap.agent.versions.DeploymentInfo;
import org.hotswap.agent.versions.InvalidVersionSpecificationException;
import org.hotswap.agent.versions.MavenInfo;
import org.hotswap.agent.versions.VersionMatchResult;
import org.hotswap.agent.versions.VersionMatcher;
import org.hotswap.agent.versions.VersionRange;

public class MavenMatcher
implements VersionMatcher {
    private static AgentLogger LOGGER = AgentLogger.getLogger(MavenMatcher.class);
    private final VersionRange includes;
    private final VersionRange excludes;
    private final String artifactId;
    private final String groupId;
    private final String includesString;
    private final String excludesString;

    public MavenMatcher(Maven cfg) throws InvalidVersionSpecificationException {
        this.artifactId = cfg.artifactId();
        this.groupId = cfg.groupId();
        if (StringUtils.hasText(cfg.value())) {
            this.includesString = cfg.value().trim();
            this.includes = VersionRange.createFromVersionSpec(this.includesString);
        } else {
            this.includes = null;
            this.includesString = null;
        }
        if (StringUtils.hasText(cfg.excludeVersion())) {
            this.excludesString = cfg.excludeVersion().trim();
            this.excludes = VersionRange.createFromVersionSpec(this.excludesString);
        } else {
            this.excludes = null;
            this.excludesString = null;
        }
    }

    public VersionRange getIncludes() {
        return this.includes;
    }

    public VersionRange getExcludes() {
        return this.excludes;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String toString() {
        return "MavenMatcher [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", includes=" + this.includes + ", excludes=" + this.excludes + "]";
    }

    @Override
    public VersionMatchResult matches(DeploymentInfo info) {
        if (info.getMaven() == null || info.getMaven().size() == 0) {
            return VersionMatchResult.SKIPPED;
        }
        for (MavenInfo mi : info.getMaven()) {
            if (!PatternMatchUtils.regexMatch(this.groupId, mi.getGroupId()) || !PatternMatchUtils.regexMatch(this.artifactId, mi.getArtifactId())) continue;
            if (!(this.includes != null && !this.includes.containsVersion(mi.getVersion()) || this.excludes != null && this.excludes.containsVersion(mi.getVersion()))) {
                LOGGER.debug("Matched {} with {}", this, mi);
                return VersionMatchResult.MATCHED;
            }
            if (this.excludes == null || !this.excludes.containsVersion(mi.getVersion())) continue;
            LOGGER.debug("Rejected {} with {}", this, mi);
            return VersionMatchResult.REJECTED;
        }
        return VersionMatchResult.SKIPPED;
    }

    @Override
    public boolean isApply() {
        return StringUtils.hasText(this.artifactId) && StringUtils.hasText(this.groupId) && (StringUtils.hasText(this.includesString) || StringUtils.hasText(this.excludesString));
    }
}

