/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.jvm;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.jvm.AnonymousClassInfo;

public class AnonymousClassInfos {
    private static AgentLogger LOGGER = AgentLogger.getLogger(AnonymousClassInfos.class);
    public static final int UNIQUE_CLASS_START_INDEX = 10000;
    private static final long ALLOWED_MODIFICATION_DELTA = 100L;
    static int uniqueClass = 10000;
    AnonymousClassInfos previous;
    Map<AnonymousClassInfo, AnonymousClassInfo> compatibleTransitions;
    long lastModifiedTimestamp = 0L;
    String className;
    List<AnonymousClassInfo> anonymousClassInfoList = new ArrayList<AnonymousClassInfo>();

    public AnonymousClassInfos(ClassLoader classLoader, String className) {
        this.className = className;
        try {
            Class anonymous;
            Method m = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            m.setAccessible(true);
            int i = 1;
            while ((anonymous = (Class)m.invoke((Object)classLoader, className + "$" + i)) != null) {
                this.anonymousClassInfoList.add(i - 1, new AnonymousClassInfo(anonymous));
                ++i;
            }
        }
        catch (Exception e) {
            throw new Error("Unexpected error in checking loaded classes", e);
        }
    }

    public AnonymousClassInfos(ClassPool classPool, String className) {
        List<CtClass> declaredClasses;
        this.className = className;
        this.lastModifiedTimestamp = this.lastModified(classPool, className);
        try {
            CtClass ctClass = classPool.get(className);
            declaredClasses = Arrays.asList(ctClass.getNestedClasses());
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Class " + className + " not found.");
        }
        int i = 1;
        try {
            CtClass anonymous;
            while (declaredClasses.contains(anonymous = classPool.get(className + "$" + i))) {
                this.anonymousClassInfoList.add(i - 1, new AnonymousClassInfo(anonymous));
                ++i;
            }
        }
        catch (NotFoundException e) {
        }
        catch (Exception e) {
            throw new Error("Unable to create AnonymousClassInfo definition for class " + className + "$i", e);
        }
        LOGGER.trace("Anonymous class '{}' scan finished with {} classes found", className, i - 1);
    }

    private void calculateCompatibleTransitions() {
        this.compatibleTransitions = new HashMap<AnonymousClassInfo, AnonymousClassInfo>();
        List<AnonymousClassInfo> previousInfos = new ArrayList<AnonymousClassInfo>(this.previous.anonymousClassInfoList);
        ArrayList<AnonymousClassInfo> currentInfos = new ArrayList<AnonymousClassInfo>(this.anonymousClassInfoList);
        if (previousInfos.size() > currentInfos.size()) {
            if (currentInfos.size() == 0) {
                previousInfos.clear();
            } else {
                previousInfos = previousInfos.subList(0, currentInfos.size());
            }
        }
        this.searchForMappings(this.compatibleTransitions, previousInfos, currentInfos, new AnonymousClassInfoMatcher(){

            @Override
            public boolean match(AnonymousClassInfo previous, AnonymousClassInfo current) {
                return previous.matchExact(current);
            }
        });
        this.searchForMappings(this.compatibleTransitions, previousInfos, currentInfos, new AnonymousClassInfoMatcher(){

            @Override
            public boolean match(AnonymousClassInfo previous, AnonymousClassInfo current) {
                return previous.matchSignatures(current);
            }
        });
        this.searchForMappings(this.compatibleTransitions, previousInfos, currentInfos, new AnonymousClassInfoMatcher(){

            @Override
            public boolean match(AnonymousClassInfo previous, AnonymousClassInfo current) {
                return previous.matchClassSignature(current);
            }
        });
        int newDefinitionCount = this.anonymousClassInfoList.size();
        int lastAnonymousClassIndex = this.previous.anonymousClassInfoList.size();
        for (AnonymousClassInfo anonymousClassInfo : currentInfos) {
            if (lastAnonymousClassIndex < newDefinitionCount) {
                this.compatibleTransitions.put(new AnonymousClassInfo(this.className + "$" + (lastAnonymousClassIndex + 1)), anonymousClassInfo);
                ++lastAnonymousClassIndex;
                continue;
            }
            this.compatibleTransitions.put(new AnonymousClassInfo(this.className + "$" + uniqueClass++), anonymousClassInfo);
        }
        if (LOGGER.isLevelEnabled(AgentLogger.Level.TRACE)) {
            for (Map.Entry entry : this.compatibleTransitions.entrySet()) {
                LOGGER.trace("Transition {} => {}", ((AnonymousClassInfo)entry.getKey()).getClassName(), ((AnonymousClassInfo)entry.getValue()).getClassName());
            }
        }
    }

    private void searchForMappings(Map<AnonymousClassInfo, AnonymousClassInfo> transitions, List<AnonymousClassInfo> previousInfos, List<AnonymousClassInfo> currentInfos, AnonymousClassInfoMatcher matcher) {
        ListIterator<AnonymousClassInfo> previousIt = previousInfos.listIterator();
        block0: while (previousIt.hasNext()) {
            AnonymousClassInfo previous = previousIt.next();
            ListIterator<AnonymousClassInfo> currentIt = currentInfos.listIterator();
            while (currentIt.hasNext()) {
                AnonymousClassInfo current = currentIt.next();
                if (!matcher.match(previous, current)) continue;
                transitions.put(previous, current);
                previousIt.remove();
                currentIt.remove();
                continue block0;
            }
        }
    }

    public AnonymousClassInfo getAnonymousClassInfo(String className) {
        for (AnonymousClassInfo info : this.anonymousClassInfoList) {
            if (!className.equals(info.getClassName())) continue;
            return info;
        }
        return null;
    }

    public void mapPreviousState(AnonymousClassInfos previousAnonymousClassInfos) {
        this.previous = previousAnonymousClassInfos;
        previousAnonymousClassInfos.previous = null;
        this.calculateCompatibleTransitions();
    }

    public boolean isCurrent(ClassPool classPool) {
        return this.lastModifiedTimestamp >= this.lastModified(classPool, this.className) - 100L;
    }

    private long lastModified(ClassPool classPool, String className) {
        URL url = classPool.find(className);
        if (url != null) {
            String file = url.getFile();
            return new File(file).lastModified();
        }
        return 0L;
    }

    public Map<AnonymousClassInfo, AnonymousClassInfo> getCompatibleTransitions() {
        return this.compatibleTransitions;
    }

    public String getCompatibleTransition(String className) {
        for (Map.Entry<AnonymousClassInfo, AnonymousClassInfo> transition : this.compatibleTransitions.entrySet()) {
            if (!transition.getKey().getClassName().equals(className)) continue;
            return transition.getValue().getClassName();
        }
        return null;
    }

    private static interface AnonymousClassInfoMatcher {
        public boolean match(AnonymousClassInfo var1, AnonymousClassInfo var2);
    }
}

