/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.jvm;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtField;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.NotFoundException;

public class AnonymousClassInfo {
    String className;
    String classSignature;
    String methodSignature;
    String fieldsSignature;
    String enclosingMethodSignature;

    public AnonymousClassInfo(Class c) {
        this.className = c.getName();
        StringBuilder classSignature = new StringBuilder(c.getSuperclass().getName());
        for (Class<?> intef : c.getInterfaces()) {
            classSignature.append(";");
            classSignature.append(intef.getName());
        }
        this.classSignature = classSignature.toString();
        StringBuilder methodsSignature = new StringBuilder();
        for (Method m : c.getDeclaredMethods()) {
            this.getMethodSignature(methodsSignature, m);
        }
        this.methodSignature = methodsSignature.toString();
        StringBuilder fieldsSignature = new StringBuilder();
        for (Field f : c.getDeclaredFields()) {
            fieldsSignature.append(f.getType().getName());
            fieldsSignature.append(" ");
            fieldsSignature.append(f.getName());
            fieldsSignature.append(";");
        }
        this.fieldsSignature = fieldsSignature.toString();
        StringBuilder enclosingMethodSignature = new StringBuilder();
        Method enclosingMethod = c.getEnclosingMethod();
        if (enclosingMethod != null) {
            this.getMethodSignature(enclosingMethodSignature, enclosingMethod);
        }
        this.enclosingMethodSignature = enclosingMethodSignature.toString();
    }

    public AnonymousClassInfo(String className) {
        this.className = className;
    }

    private void getMethodSignature(StringBuilder methodsSignature, Method m) {
        methodsSignature.append(m.getReturnType().getName());
        methodsSignature.append(" ");
        methodsSignature.append(m.getName());
        methodsSignature.append("(");
        for (Class<?> paramType : m.getParameterTypes()) {
            methodsSignature.append(paramType.getName());
        }
        methodsSignature.append(")");
        methodsSignature.append(";");
    }

    public AnonymousClassInfo(CtClass c) {
        try {
            this.className = c.getName();
            StringBuilder classSignature = new StringBuilder(c.getSuperclassName());
            for (CtClass intef : c.getInterfaces()) {
                classSignature.append(";");
                classSignature.append(intef.getName());
            }
            this.classSignature = classSignature.toString();
            StringBuilder methodsSignature = new StringBuilder();
            for (CtMethod m : c.getDeclaredMethods()) {
                this.getMethodSignature(methodsSignature, m);
            }
            this.methodSignature = methodsSignature.toString();
            StringBuilder fieldsSignature = new StringBuilder();
            for (CtField f : c.getDeclaredFields()) {
                fieldsSignature.append(f.getType().getName());
                fieldsSignature.append(" ");
                fieldsSignature.append(f.getName());
                fieldsSignature.append(";");
            }
            this.fieldsSignature = fieldsSignature.toString();
            StringBuilder enclosingMethodSignature = new StringBuilder();
            try {
                CtMethod enclosingMethod = c.getEnclosingMethod();
                if (enclosingMethod != null) {
                    this.getMethodSignature(enclosingMethodSignature, enclosingMethod);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.enclosingMethodSignature = enclosingMethodSignature.toString();
        }
        catch (Throwable t) {
            throw new IllegalStateException("Error creating AnonymousClassInfo from " + c.getName(), t);
        }
    }

    private void getMethodSignature(StringBuilder methodsSignature, CtMethod m) throws NotFoundException {
        methodsSignature.append(m.getReturnType().getName());
        methodsSignature.append(" ");
        methodsSignature.append(m.getName());
        methodsSignature.append("(");
        for (CtClass paramType : m.getParameterTypes()) {
            methodsSignature.append(paramType.getName());
        }
        methodsSignature.append(")");
        methodsSignature.append(";");
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassSignature() {
        return this.classSignature;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String getFieldsSignature() {
        return this.fieldsSignature;
    }

    public String getEnclosingMethodSignature() {
        return this.enclosingMethodSignature;
    }

    public boolean matchExact(AnonymousClassInfo other) {
        return this.getClassSignature().equals(other.getClassSignature()) && this.getMethodSignature().equals(other.getMethodSignature()) && this.getFieldsSignature().equals(other.getFieldsSignature()) && this.getEnclosingMethodSignature().equals(other.getEnclosingMethodSignature());
    }

    public boolean matchSignatures(AnonymousClassInfo other) {
        return this.getClassSignature().equals(other.getClassSignature()) && this.getMethodSignature().equals(other.getMethodSignature()) && this.getFieldsSignature().equals(other.getFieldsSignature());
    }

    public boolean matchClassSignature(AnonymousClassInfo other) {
        return this.getClassSignature().equals(other.getClassSignature());
    }
}

