/*
 * Decompiled with CFR 0.152.
 */
package jcifs.spnego;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import jcifs.spnego.SpnegoToken;
import jcifs.spnego.asn1.ASN1EncodableVector;
import jcifs.spnego.asn1.ASN1OctetString;
import jcifs.spnego.asn1.ASN1Sequence;
import jcifs.spnego.asn1.ASN1TaggedObject;
import jcifs.spnego.asn1.DERBitString;
import jcifs.spnego.asn1.DERInputStream;
import jcifs.spnego.asn1.DERObjectIdentifier;
import jcifs.spnego.asn1.DEROctetString;
import jcifs.spnego.asn1.DEROutputStream;
import jcifs.spnego.asn1.DERSequence;
import jcifs.spnego.asn1.DERTaggedObject;
import jcifs.spnego.asn1.DERUnknownTag;

public class NegTokenInit
extends SpnegoToken {
    public static final int DELEGATION = 64;
    public static final int MUTUAL_AUTHENTICATION = 32;
    public static final int REPLAY_DETECTION = 16;
    public static final int SEQUENCE_CHECKING = 8;
    public static final int ANONYMITY = 4;
    public static final int CONFIDENTIALITY = 2;
    public static final int INTEGRITY = 1;
    private String[] mechanisms;
    private int contextFlags;

    public NegTokenInit() {
    }

    public NegTokenInit(String[] mechanisms, int contextFlags, byte[] mechanismToken, byte[] mechanismListMIC) {
        this.setMechanisms(mechanisms);
        this.setContextFlags(contextFlags);
        this.setMechanismToken(mechanismToken);
        this.setMechanismListMIC(mechanismListMIC);
    }

    public NegTokenInit(byte[] token) throws IOException {
        this.parse(token);
    }

    public int getContextFlags() {
        return this.contextFlags;
    }

    public void setContextFlags(int contextFlags) {
        this.contextFlags = contextFlags;
    }

    public boolean getContextFlag(int flag) {
        return (this.getContextFlags() & flag) == flag;
    }

    public void setContextFlag(int flag, boolean value) {
        this.setContextFlags(value ? this.getContextFlags() | flag : this.getContextFlags() & (0xFFFFFFFF ^ flag));
    }

    public String[] getMechanisms() {
        return this.mechanisms;
    }

    public void setMechanisms(String[] mechanisms) {
        this.mechanisms = mechanisms;
    }

    public byte[] toByteArray() {
        try {
            byte[] mechanismListMIC;
            byte[] mechanismToken;
            int contextFlags;
            ByteArrayOutputStream collector = new ByteArrayOutputStream();
            DEROutputStream der = new DEROutputStream(collector);
            der.writeObject(new DERObjectIdentifier("1.3.6.1.5.5.2"));
            ASN1EncodableVector fields = new ASN1EncodableVector();
            String[] mechanisms = this.getMechanisms();
            if (mechanisms != null) {
                ASN1EncodableVector vector = new ASN1EncodableVector();
                for (int i = 0; i < mechanisms.length; ++i) {
                    vector.add(new DERObjectIdentifier(mechanisms[i]));
                }
                fields.add(new DERTaggedObject(true, 0, new DERSequence(vector)));
            }
            if ((contextFlags = this.getContextFlags()) != 0) {
                fields.add(new DERTaggedObject(true, 1, new DERBitString(contextFlags)));
            }
            if ((mechanismToken = this.getMechanismToken()) != null) {
                fields.add(new DERTaggedObject(true, 2, new DEROctetString(mechanismToken)));
            }
            if ((mechanismListMIC = this.getMechanismListMIC()) != null) {
                fields.add(new DERTaggedObject(true, 3, new DEROctetString(mechanismListMIC)));
            }
            der.writeObject(new DERTaggedObject(true, 0, new DERSequence(fields)));
            DERUnknownTag token = new DERUnknownTag(96, collector.toByteArray());
            collector = new ByteArrayOutputStream();
            der = new DEROutputStream(collector);
            der.writeObject(token);
            return collector.toByteArray();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex.getMessage());
        }
    }

    protected void parse(byte[] token) throws IOException {
        ByteArrayInputStream tokenStream = new ByteArrayInputStream(token);
        DERInputStream der = new DERInputStream(tokenStream);
        DERUnknownTag constructed = (DERUnknownTag)der.readObject();
        if (constructed.getTag() != 96) {
            throw new IOException("Malformed NegTokenInit.");
        }
        tokenStream = new ByteArrayInputStream(constructed.getData());
        der = new DERInputStream(tokenStream);
        DERObjectIdentifier spnego = (DERObjectIdentifier)der.readObject();
        ASN1TaggedObject tagged = (ASN1TaggedObject)der.readObject();
        ASN1Sequence sequence = ASN1Sequence.getInstance(tagged, true);
        Enumeration fields = sequence.getObjects();
        block6: while (fields.hasMoreElements()) {
            tagged = (ASN1TaggedObject)fields.nextElement();
            switch (tagged.getTagNo()) {
                case 0: {
                    sequence = ASN1Sequence.getInstance(tagged, true);
                    String[] mechanisms = new String[sequence.size()];
                    for (int i = mechanisms.length - 1; i >= 0; --i) {
                        DERObjectIdentifier mechanism = (DERObjectIdentifier)sequence.getObjectAt(i);
                        mechanisms[i] = mechanism.getId();
                    }
                    this.setMechanisms(mechanisms);
                    continue block6;
                }
                case 1: {
                    DERBitString contextFlags = DERBitString.getInstance(tagged, true);
                    this.setContextFlags(contextFlags.getBytes()[0] & 0xFF);
                    continue block6;
                }
                case 2: {
                    ASN1OctetString mechanismToken = ASN1OctetString.getInstance(tagged, true);
                    this.setMechanismToken(mechanismToken.getOctets());
                    continue block6;
                }
                case 3: {
                    ASN1OctetString mechanismListMIC = ASN1OctetString.getInstance(tagged, true);
                    this.setMechanismListMIC(mechanismListMIC.getOctets());
                    continue block6;
                }
            }
            throw new IOException("Malformed token field.");
        }
    }
}

